

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsSchdBackupTypeIncr.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsSchdBackupTypeIncr'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsSchdBackupTypeIncr]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsSchdBackupTypeIncr]
  delete from GXDBVersions where name = 'IsSchdBackupTypeIncr' and type = 5
END
GO

	CREATE  FUNCTION IsSchdBackupTypeIncr (@AppTypeID int, @AppId int, @BackupType int)
	RETURNS INT
	-- WITH ENCRYPTION
	BEGIN
		IF ( @AppTypeID IN (45,56,57,58,66,73,82,83,89,90) AND ((@BackupType = 2) OR (@BackupType & 0x800000 = 0x800000)) )
		BEGIN
			DECLARE		@NewIdxCycle	integer
			DECLARE		@CurrentIdxCycle	integer
			SET @NewIdxCycle = (SELECT CAST(SCP.attrVal AS INT)
						FROM APP_SubClientProp AS SCP
						WHERE SCP.ComponentNameID = @AppID
							AND attrName = 'New Index Cycle'
							AND modified = 0)
			SET @CurrentIdxCycle = (SELECT CAST(SCP.attrVal AS INT)
						FROM APP_SubClientProp AS SCP
						WHERE SCP.ComponentNameID = @AppID
							AND attrName = 'Archival Cycle Num'
							AND modified = 0)
			IF ( (@CurrentIdxCycle >= @NewIdxCycle)  )
				RETURN 0
			ELSE
				RETURN 1
		END
		ELSE IF ( @AppTypeID IN (8, 9, 14, 15, 26, 27, 30, 31, 35, 44, 45, 53, 54, 55, 56, 57, 67, 68, 82, 105) AND (@BackupType & 0x1000000 = 0x1000000) )
		BEGIN
			DECLARE		@BackupLevel	integer
			SET @BackupLevel = ISNULL( (SELECT CAST(SCP.attrVal AS INT)
						FROM APP_SubClientProp AS SCP
						WHERE SCP.ComponentNameID = @AppID
							AND SCP.attrName = 'Backup Level'
							AND SCP.modified = 0), 0x02)
			IF (@BackupLevel = 0x02)
				RETURN 1
			ELSE
				RETURN 0
		END
		ELSE
		BEGIN
			IF ( @AppTypeID IN (47, 50) AND (@BackupType & 0x100000 = 0x100000))
				RETURN 1
			ELSE
				RETURN 0
		END
		RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsSchdBackupTypeIncr]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsSchdBackupTypeIncr' AND revision = '1.2.276.1')

  insert into GXDBVersions values(5, 'IsSchdBackupTypeIncr',  '1.2.276.1', 'IsSchdBackupTypeIncr', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
