

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsPseudoClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsPseudoClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsPseudoClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsPseudoClient]
  delete from GXDBVersions where name = 'IsPseudoClient' and type = 5
END
GO

	CREATE FUNCTION IsPseudoClient(@clientId integer)
	RETURNS INT
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INT = 0
		DECLARE @status INT = 0
		DECLARE @specialClientFlags INT = 0

		-- PROCCED ONLY IF NO PACKAGES EXIST, ELSE ITS NOT A PSEUDO CLIENT
		IF EXISTS (SELECT * FROM SIMINSTALLEDPACKAGES WHERE clientId = @clientId)
		BEGIN
			SET @result = 0
			RETURN @result
		END

		SELECT @status = C.status , @specialClientFlags = specialClientFlags  FROM APP_CLIENT C WHERE C.id = @clientId

		-- DEPENDENT on status flags (DAG/RAC/DB2DBF/NAS/REFERENCE COPY)
		SET @result = (SELECT CASE
			WHEN (@status & 0x0040    ) > 0 THEN 1
			WHEN (@status & 0x0080			) > 0 THEN 1
			WHEN (@status & 0x0200       ) > 0 THEN 1
			WHEN (@status & 0x200000			) > 0 THEN 1
			WHEN (@status & 0x400000 ) > 0 THEN 1
			WHEN (@status & 0x4000000) > 0 THEN 1
			WHEN (@status & 0x2000000		) > 0 THEN 1
			WHEN (@status & 0x20000000		) > 0 THEN 1
			END)

		IF @result = 1
			RETURN @result


		-- DISCOVERED CLIENTS
		IF EXISTS(SELECT ACP.componentNameId  FROM APP_ClientProp ACP WHERE ACP.componentNameId = @clientId AND ( ACP.attrName in ('Virtual Server Discovered Clients','SharePoint Farm Client','Mini SRM Agent' ) ) AND attrval = '1')
		BEGIN
			SET @result = 1
			RETURN @result
		END

		-- VS PSEUDO CLIENTS
		IF EXISTS(select distinct Ida.id from app_idaprop IdaProp,APP_IDAName Ida where Ida.clientId = @clientId and IdaProp.componentNameId = Ida.id and attrName = 'Pseudo Apptype' and attrVal = '1')
		BEGIN
			SET @result = 1
			RETURN @result
		END

		-- OPENVMS CLIENTS	N_CV_OS_ID_OPENVMS = 38
		IF EXISTS(SELECT * FROM APP_Client WHERE id = @clientId AND simOperatingSystemId = 38)
		BEGIN
			SET @result = 1
			RETURN @result
		END

		--EDC CLIENTS
		IF EXISTS(SELECT  * FROM app_clientgroup CG INNER JOIN app_clientGroupAssoc CGA  ON CG.id = CGA.clientGroupId and CGA.clientId = @clientId
			WHERE ((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200)))
		BEGIN
			SET @result = 1
			RETURN @result
		END

		-- WINDOWS/LINUX DUMMY CLIENTS -- SAME_COMMCELL_GALAXY_PACKAGES_ABSENT. THIS FLAG WOULD BE SET FOR PACKAGES WHICH IS UINSTALLED. SO ADD ADDITIONAL CHECKS
		IF(@specialClientFlags & 0x02) <> 0
		BEGIN
			IF EXISTS(SELECT * FROM APP_APPLICATION WHERE clientId = @clientId) OR EXISTS(SELECT * FROM LICUSAGE WHERE Cid = @clientId)
				SET @result = 0
			ELSE
				SET @result = 1
		END

		RETURN ISNULL(@result,0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsPseudoClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsPseudoClient' AND revision = '1.3.60.3')

  insert into GXDBVersions values(5, 'IsPseudoClient',  '1.3.60.3', 'IsPseudoClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
