

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsPartialSnapAgingAllowed.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsPartialSnapAgingAllowed'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsPartialSnapAgingAllowed]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsPartialSnapAgingAllowed]
  delete from GXDBVersions where name = 'IsPartialSnapAgingAllowed' and type = 5
END
GO

 			create function IsPartialSnapAgingAllowed(@jobId INT, @commCellId INT)
 			returns INT
 			as
 			begin
 				DECLARE @appType INT = 0
				DECLARE @retVal INT = 0
				-- Partial aging of snaps is supported only for NAS iDA and VVol snaps.
				SELECT @appType = appType FROM JMBkpStats (NOLOCK) WHERE jobId = @jobId and commCellId = @commCellId
				IF @appType = 13
					SET @retVal = 1
				ELSE IF EXISTS (SELECT 1 FROM SMVolume(NOLOCK) WHERE jobId = @jobId and commCellId = @commCellId
									AND VolumeFlags & 33554432 = 33554432)
					SET @retVal = 1
				ELSE
					SET @retVal = 0
				RETURN @retVal
 			end


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsPartialSnapAgingAllowed]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsPartialSnapAgingAllowed' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'IsPartialSnapAgingAllowed',  '1.1.2.3', 'IsPartialSnapAgingAllowed', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
