

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsOperationAllowedAndMatchedLevel.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: IsOperationAllowedAndMatchedLevel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsOperationAllowedAndMatchedLevel]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsOperationAllowedAndMatchedLevel]
  delete from GXDBVersions where name = 'IsOperationAllowedAndMatchedLevel' and type = 5
END
GO

    SET QUOTED_IDENTIFIER ON
    GO
	CREATE FUNCTION IsOperationAllowedAndMatchedLevel
	(
	 @operationType	INTEGER, --Required
	 @commCellID	INTEGER, --Required
	 @clientID		INTEGER, --Required
	 @appType		INTEGER, --Required to do CS level alone (apptype= 1000)
	 @instacenId	INTEGER, --Optional
	 @backupsetID	INTEGER, --Optional
	 @subClientID	INTEGER, --Optional
	 @schedulePolicyId INTEGER, --Optional
	 @checkJobStart	INTEGER
	)
	RETURNS @OperationAndLevelTbl TABLE (isOperationAllowed INTEGER, MatchLevel INTEGER,utilization INTEGER)
	AS
	BEGIN
		-- Any Failure in execution we will return 1 allowing the job to run


		DECLARE @now INTEGER= dbo.GetUnixTime(GetUTCDate()) --Get the current time in UTC here
		DECLARE @month       integer
		DECLARE @weekday     integer
		DECLARE @hour     integer
		DECLARE @minute     integer
		DECLARE @second     integer
		DECLARE @year     integer
		DECLARE @day     integer
		DECLARE @allowed     integer = 1
		DECLARE @matchLevel     integer = -1
		DECLARE @utilization     integer = 100
		DECLARE @ignoreHigherLevelRules     integer = 0
		DECLARE @operationTime     integer = 0
		DECLARE @operationDate     integer = 0
		DECLARE @ClientTime DATETIME
		DECLARE @localMidMightEpoch INTEGER

		DECLARE @WEEK_OF_THE_MONTH_FIRST	INT = 0x01
		DECLARE @WEEK_OF_THE_MONTH_SECOND	INT	= 0x02
		DECLARE @WEEK_OF_THE_MONTH_THIRD	INT = 0x04
		DECLARE @WEEK_OF_THE_MONTH_FOURTH	INT = 0x08
		DECLARE @WEEK_OF_THE_MONTH_LAST		INT = 0x10
		DECLARE @WEEK_OF_THE_MONTH_ALL		INT = 0x20
		IF @appType = 1000 --When check is required at CS level alone
			SET @clientID = 2

		SELECT @ClientTime = clientTime,@year = year,@month = month,@weekday = weekday,@day = day, @hour = hour, @minute = minute,@second = seconds , @localMidMightEpoch = localMidNightEpoch
			FROM dbo.GetUTCToClientLocalTimeInParts(@now,@clientID)

		IF @ClientTime IS NULL --Some error occured and we failed to get client time, Let the jon run
		BEGIN
			INSERT INTO @OperationAndLevelTbl VALUES (@allowed,@matchLevel,@utilization)
			RETURN;
		END

		SET @operationTime = 3600 * @hour + 60 * @minute + @second --Compute the time of day in seconds
		SET @operationDate = @localMidMightEpoch
		DECLARE @cliWeek INT, @cliWeekBit INT, @iscliLastWeek INT, @cliMonth INT, @cliYear INT
		SELECT @cliMonth = DATEPART(MONTH, @ClientTime)
		SELECT @cliYear = DATEPART(YEAR, @ClientTime)
		SELECT @cliWeek = DATEDIFF(WEEK, DATEADD(MONTH, DATEDIFF(MONTH, 0, @ClientTime), 0), @ClientTime) +1
		SELECT @cliWeekBit = (CASE @cliWeek
									WHEN 1 THEN 0x01
									WHEN 2 THEN 0x02
									WHEN 3 THEN 0x04
									WHEN 4 THEN 0x08
									WHEN 5 THEN 0x10
							END)
		SELECT @iscliLastWeek = (CASE WHEN numberOfWeeks = @cliWeek THEN 1 ELSE 0 END)
			FROM APP_YearMonthNumberOfWeeks
			WHERE yearNo = @cliYear
			AND monthNo = @cliMonth

		--Convert WeekDay into macros OP_SUNDAY (1<<0) ,  OP_MONDAY (1<<1), OP_TUESDAY (1<<2),  OP_WEDNESDAY (1<<3), OP_THURSDAY (1<<4),  OP_FRIDAY (1<<5), OP_SATURDAY (1<<6) defined in AppMgrDefines.h
		-- ie 1 << (WeekDay-1)
		SET @weekday = POWER(2,@weekday-1)

		IF @appType = 1000
		BEGIN

				IF EXISTS (SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
				WHERE clientId = @clientID AND appTypeId = @appType AND (((opType & @operationType ) = @operationType ) OR ((opType & 1048576 ) = 1048576/*OPERATION_ALL*/ )) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((weekOfTheMonth & @cliWeekBit) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL )) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
				AND (@checkJobStart = 0 OR doNotSubmitJob = 1)  ) -- By default @checkJobStart will be passed as 0 and all rows will be matched as before. When TM calls to check whether we can start job, then we need to consider doNotSubmitJob flag
				BEGIN
					SET @allowed = 0
					SET @matchLevel = 0
					SET @utilization = (SELECT TOP 1 utilization FROM APP_OpWindowRule WITH(NOLOCK)
							WHERE clientId = @clientID AND appTypeId = @appType AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
										ORDER BY utilization)
				END

				INSERT INTO @OperationAndLevelTbl VALUES (@allowed,@matchLevel,@utilization)
				RETURN;

		END
		ELSE
		BEGIN
				IF @subClientID <> 0 --subclient level
				BEGIN

					IF EXISTS (SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
						WHERE subclientId = @subClientID AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((weekOfTheMonth & @cliWeekBit) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL )) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1
					AND (@checkJobStart = 0 OR doNotSubmitJob = 1)  ) -- By default @checkJobStart will be passed as 0 and all rows will be matched as before. When TM calls to check whether we can start job, then we need to consider doNotSubmitJob flag
					BEGIN
						SET @allowed = 0
						SET @matchLevel = 6
						SET @utilization = (SELECT TOP 1 utilization FROM APP_OpWindowRule WITH(NOLOCK)
												WHERE subclientId = @subClientID AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1
													ORDER BY utilization)
					END

				END
				--Check if Higher Op window rules has to be ignored
				IF EXISTS (SELECT 1 FROM APP_SubClientProp WITH(NOLOCK)
					WHERE componentNameID = @subClientID and attrName like 'Ignore commcell operation rule'
						AND modified = 0 and attrVal = '1')
				BEGIN
						SET @ignoreHigherLevelRules = 1
				END


				IF @ignoreHigherLevelRules = 0 AND @allowed = 1 AND @backupsetID <> 0 --backup set level
				BEGIN

					IF EXISTS (SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
						WHERE backupSetId  = @backupsetID AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((weekOfTheMonth & @cliWeekBit) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL )) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND subclientId = 0
						AND (@checkJobStart = 0 OR doNotSubmitJob = 1)  ) -- By default @checkJobStart will be passed as 0 and all rows will be matched as before. When TM calls to check whether we can start job, then we need to consider doNotSubmitJob flag
					BEGIN
						SET @allowed = 0
						SET @matchLevel = 5
						SET @utilization = (SELECT TOP 1 utilization FROM APP_OpWindowRule WITH(NOLOCK)
												WHERE backupSetId  = @backupsetID AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND subclientId = 0
													ORDER BY utilization)
					END

				END


				IF @ignoreHigherLevelRules = 0 AND EXISTS (SELECT 1 FROM APP_BackupSetProp WITH(NOLOCK)
					WHERE componentNameID = @backupsetID and attrName like 'Ignore commcell operation rule'
						AND modified = 0 and attrVal = '1')
				BEGIN
					SET @ignoreHigherLevelRules = 1
				END


				IF @ignoreHigherLevelRules = 0 AND @allowed = 1 AND @instacenId <> 0 --instance level
				BEGIN


					IF EXISTS (SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
						WHERE clientId = @clientID AND appTypeId = @appType AND instanceId = @instacenId AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((weekOfTheMonth & @cliWeekBit) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL )) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND backupsetId = 0 AND subclientId = 0
						AND (@checkJobStart = 0 OR doNotSubmitJob = 1)  ) -- By default @checkJobStart will be passed as 0 and all rows will be matched as before. When TM calls to check whether we can start job, then we need to consider doNotSubmitJob flag
					BEGIN
						SET @allowed = 0
						SET @matchLevel = 4
						SET @utilization = (SELECT TOP 1 utilization FROM APP_OpWindowRule WITH(NOLOCK)
												WHERE clientId = @clientID AND appTypeId = @appType AND instanceId = @instacenId AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND backupsetId = 0 AND subclientId = 0
													ORDER BY utilization)
					END


				END


				IF @ignoreHigherLevelRules = 0 AND EXISTS (SELECT 1 FROM APP_InstanceProp WITH(NOLOCK)
					WHERE componentNameID = @instacenId and attrName like 'Ignore commcell operation rule'
						AND modified = 0 and attrVal = '1')
				BEGIN
					SET @ignoreHigherLevelRules = 1
				END


				IF @ignoreHigherLevelRules = 0 AND @allowed = 1 AND @appType <> 0 -- ida level
				BEGIN

					IF EXISTS (SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
						WHERE clientId = @clientID AND appTypeId = @appType AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((weekOfTheMonth & @cliWeekBit) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL )) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
					AND (@checkJobStart = 0 OR doNotSubmitJob = 1)  ) -- By default @checkJobStart will be passed as 0 and all rows will be matched as before. When TM calls to check whether we can start job, then we need to consider doNotSubmitJob flag
					BEGIN
						SET @allowed = 0
						SET @matchLevel = 3
						SET @utilization = (SELECT TOP 1 utilization FROM APP_OpWindowRule WITH(NOLOCK)
												WHERE clientId = @clientID AND appTypeId = @appType AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
													ORDER BY utilization)
					END

				END


				IF @ignoreHigherLevelRules = 0 AND EXISTS (SELECT 1 FROM APP_IDAProp WITH(NOLOCK)-- We get some TRs with dupliccate entry in APP_IDAName table, Hence added TOP 1 so that query wont fail though result may be wrong
					WHERE componentNameID = (SELECT TOP 1 id FROM APP_IDAName WITH(NOLOCK) WHERE clientId = @clientID AND appTypeId = @appType) and attrName like 'Ignore commcell operation rule'
						AND modified = 0 and attrVal = '1')
				BEGIN
					SET @ignoreHigherLevelRules = 1
				END


				IF @ignoreHigherLevelRules = 0 AND @allowed = 1 AND @clientID <> 0 --client level
				BEGIN

					IF EXISTS (SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
						WHERE clientId = @clientID AND appTypeId = 0 AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((weekOfTheMonth & @cliWeekBit) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL )) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1
						AND (@checkJobStart = 0 OR doNotSubmitJob = 1)  ) -- By default @checkJobStart will be passed as 0 and all rows will be matched as before. When TM calls to check whether we can start job, then we need to consider doNotSubmitJob flag)
					BEGIN
						SET @allowed = 0
						SET @matchLevel = 2
						SET @utilization = (SELECT TOP 1 utilization FROM APP_OpWindowRule WITH(NOLOCK)
												WHERE clientId = @clientID AND appTypeId = 0 AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1
													ORDER BY utilization)
					END

				END


				IF @ignoreHigherLevelRules = 0 AND EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK)
					WHERE componentNameID = @clientID and attrName like 'Ignore commcell operation rule'
						AND modified = 0 and attrVal = '1')
				BEGIN
					SET @ignoreHigherLevelRules = 1
				END


				IF @ignoreHigherLevelRules = 0 AND @allowed = 1 AND @clientID <> 0 --Client group level
				BEGIN

					IF EXISTS (SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
						WHERE clientGroupId IN (SELECT clientGroupId From App_ClientGroupAssoc WITH (NOLOCK) where clientId = @clientID) AND appTypeId = 0  AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((weekOfTheMonth & @cliWeekBit) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL )) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1
						AND (@checkJobStart = 0 OR doNotSubmitJob = 1)  ) -- By default @checkJobStart will be passed as 0 and all rows will be matched as before. When TM calls to check whether we can start job, then we need to consider doNotSubmitJob flag
					BEGIN
						SET @allowed = 0
						SET @matchLevel = 1
						SET @utilization = (SELECT TOP 1 utilization FROM APP_OpWindowRule WITH(NOLOCK)
												WHERE clientGroupId IN (SELECT clientGroupId From App_ClientGroupAssoc WITH (NOLOCK) where clientId = @clientID) AND appTypeId = 0  AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1
													ORDER BY utilization)
					END

				END

				IF @ignoreHigherLevelRules = 0 AND @allowed = 1 AND @schedulePolicyId <> 0 AND @clientID <> 0-- Schedule Policy Level, Needs clientid, otherwise we do not know what timzone to follow.
				BEGIN

					IF EXISTS (SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
						WHERE schedulePolicyId = @schedulePolicyId AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((weekOfTheMonth & @cliWeekBit) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL )) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1
						AND (@checkJobStart = 0 OR doNotSubmitJob = 1)  ) -- By default @checkJobStart will be passed as 0 and all rows will be matched as before. When TM calls to check whether we can start job, then we need to consider doNotSubmitJob flag
					BEGIN
						DECLARE @taskType INT = (SELECT TOP 1 taskType FROM TM_Task WITH(NOLOCK) WHERE taskId = @schedulePolicyId)
						SET @allowed = 0
						SET @matchLevel = (CASE WHEN @taskType = 4 THEN 7 ELSE 8 END) -- OPRULE_SCHEDULEPOLICY, OPRULE_SCHEDULE
						SET @utilization =  (SELECT TOP 1 utilization FROM APP_OpWindowRule WITH(NOLOCK)
												WHERE schedulePolicyId = @schedulePolicyId AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1
													ORDER BY utilization)
					END

				END

		END

		IF @ignoreHigherLevelRules = 0 AND  @allowed = 1--Now check at CS level
		BEGIN

				SET @clientID = 2
				SELECT @ClientTime = clientTime,@year = year,@month = month,@weekday = weekday,@day = day, @hour = hour, @minute = minute,@second = seconds,@localMidMightEpoch = localMidNightEpoch
					FROM dbo.GetUTCToClientLocalTimeInParts(@now,@clientID)

				SET @operationTime = 3600 * @hour + 60 * @minute + @second --Compute the time of day in seconds
				SET @operationDate = @localMidMightEpoch --Compute the mid night time Bug Fix: Should be taken form GetUTCToClientLocalTimeInParts function just like earlier in this function

				--Convert WeekDay into macros OP_SUNDAY (1<<0) ,  OP_MONDAY (1<<1), OP_TUESDAY (1<<2),  OP_WEDNESDAY (1<<3), OP_THURSDAY (1<<4),  OP_FRIDAY (1<<5), OP_SATURDAY (1<<6) defined in AppMgrDefines.h
				-- ie 1 << (WeekDay-1)
				SET @weekday = POWER(2,@weekday-1)

				SELECT @cliWeek = DATEDIFF(WEEK, DATEADD(MONTH, DATEDIFF(MONTH, 0, @ClientTime), 0), @ClientTime) +1
				SELECT @cliWeekBit = (CASE @cliWeek
										WHEN 1 THEN 0x01
										WHEN 2 THEN 0x02
										WHEN 3 THEN 0x04
										WHEN 4 THEN 0x08
										WHEN 5 THEN 0x10
									END)
				SELECT @cliMonth = DATEPART(MONTH, @ClientTime)
				SELECT @cliYear = DATEPART(YEAR, @ClientTime)
				SELECT @iscliLastWeek = (CASE WHEN numberOfWeeks = @cliWeek THEN 1 ELSE 0 END)
					FROM APP_YearMonthNumberOfWeeks
					WHERE yearNo = @cliYear
					AND monthNo = @cliMonth

				IF EXISTS (SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
				WHERE clientId = 2 AND appTypeId = 1000 AND (((opType & @operationType ) = @operationType ) OR ((opType & 1048576 ) = 1048576/*OPERATION_ALL*/ )) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((weekOfTheMonth & @cliWeekBit) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL )) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
					AND (@checkJobStart = 0 OR doNotSubmitJob = 1)  ) -- By default @checkJobStart will be passed as 0 and all rows will be matched as before. When TM calls to check whether we can start job, then we need to consider doNotSubmitJob flag
				BEGIN
					SET @allowed = 0
					SET @matchLevel = 0
					SET @utilization = (SELECT TOP 1 utilization FROM APP_OpWindowRule WITH(NOLOCK)
											WHERE clientId = 2 AND appTypeId = 1000 AND ((opType & @operationType ) = @operationType ) AND ((daysOfWeek & @weekday ) = @weekday ) AND (startTime <= @operationTime) AND (endTime >= @operationTime) AND (((startDate = 0) OR (startDate <= @operationDate)) AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
													ORDER BY utilization)
				END

		END
		INSERT INTO @OperationAndLevelTbl VALUES (@allowed,@matchLevel,@utilization)
		RETURN;
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsOperationAllowedAndMatchedLevel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsOperationAllowedAndMatchedLevel' AND revision = '')

  insert into GXDBVersions values(5, 'IsOperationAllowedAndMatchedLevel',  '', 'IsOperationAllowedAndMatchedLevel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
