

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsEntityInAssocList.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: IsEntityInAssocList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsEntityInAssocList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsEntityInAssocList]
  delete from GXDBVersions where name = 'IsEntityInAssocList' and type = 5
END
GO

CREATE FUNCTION IsEntityInAssocList (@entity xml , @entityList xml,@alertId INT)
RETURNS INTEGER
AS
BEGIN
DECLARE @retval INT
DECLARE @handle INT
DECLARE @PrepareXmlStatus INT
DECLARE @_type_ INT
DECLARE @commcellId INT
DECLARE @clientGroupId INT
DECLARE @clientId INT
DECLARE @applicationId INT
DECLARE @instanceId INT
DECLARE @backupsetId INT
DECLARE @subclientId INT
DECLARE @mediaAgentId INT
DECLARE @libraryId INT
DECLARE @storagePolicyId INT
DECLARE @schedulePolicyId INT
DECLARE @copyID INT
DECLARE @trackingPolicyId INT
DECLARE @workflowId INT
DECLARE @criteriaId INT
DECLARE @userGroupId INT
DECLARE @userId INT
DECLARE @shareId INT
DECLARE @actionsAllowed INT
DECLARE @alertType INT = 0
SELECT @alertType = alertTypeID FROM NTNotificationRule
WHERE Id = @alertID
DECLARE @EntityListTableTemp TABLE
(
    _type_  INT,
    clientGroupId INT,
    clientId INT,
    applicationId  INT,
    instanceId  INT,
    backupsetId INT,
    subclientId INT,
    mediaAgentId INT ,
    schedulePolicyId INT ,
    libraryId INT ,
    storagePolicyId INT ,
    copyId  INT ,
    trackingPolicyId INT,
    workflowId INT,
    criteriaId INT,
	userGroupId INT,
	userId INT,
	shareId INT,
    exclude INT
)
INSERT INTO @EntityListTableTemp
(   _type_ ,
    clientGroupId,
    clientId,
    applicationId ,
    instanceId ,
    backupsetId ,
    subclientId,
    mediaAgentId,
    schedulePolicyId,
    libraryId,
    storagePolicyId,
    copyId,
    trackingPolicyId,
    workflowId,
    criteriaId,
	userGroupId,
	userId,
	shareId,
    exclude
)
SELECT
    ISNULL(ref.value('@_type_','INT'),0),
    ISNULL(ref.value('@clientGroupId','INT'),0),
    ISNULL(ref.value('@clientId','INT'),0),
    ISNULL(ref.value('@applicationId','INT'),0),
    ISNULL(ref.value('@instanceId','INT'),0),
    ISNULL(ref.value('@backupsetId','INT'),0),
    ISNULL(ref.value('@subclientId','INT'),0),
    ISNULL(ref.value('@mediaAgentId','INT'),0),
    ISNULL(ref.value('@schedulePolicyId','INT'),0),
    ISNULL(ref.value('@libraryId','INT'),0),
    ISNULL(ref.value('@storagePolicyId','INT'),0),
    ISNULL(ref.value('@copyId','INT'),0),
    ISNULL(ref.value('@trackingPolicyId','INT'),0),
    ISNULL(ref.value('@workflowId','INT'),0),
    ISNULL(ref.value('@criteriaId','INT'),0),
    ISNULL(ref.value('@userGroupId','INT'),0),
    ISNULL(ref.value('@userId','INT'),0),
	ISNULL(ref.value('@shareId','INT'),0),
    ISNULL(ref.value('(flags/@exclude)[1]','INT'),0)
FROM @entityList.nodes ('/App_Associations/entity') R(ref)
SELECT
    @_type_ = ISNULL(ref.value('@_type','INT'),0) ,
    @clientgroupid = ISNULL(ref.value('@clientGroupId','INT'),0) ,
    @clientId = ISNULL(ref.value('@clientId','INT'),0),
    @applicationId = ISNULL(ref.value('@applicationId','INT'),0),
    @instanceId = ISNULL(ref.value('@instanceId','INT'),0),
    @backupsetId = ISNULL(ref.value('@backupsetId','INT'),0),
    @subclientId = ISNULL(ref.value('@subclientId','INT'),0),
    @mediaAgentId = ISNULL(ref.value('@mediaAgentId','INT'),0),
    @schedulePolicyId = ISNULL(ref.value('@schedulePolicyId','INT'),0),
    @libraryId = ISNULL(ref.value('@libraryId','INT'),0),
    @storagePolicyId = ISNULL(ref.value('@storagePolicyId','INT'),0),
    @copyId = ISNULL(ref.value('@copyId','INT'),0),
    @trackingPolicyId = ISNULL(ref.value('@trackingPolicyId','INT'),0),
        @workflowId = ISNULL(ref.value('@workflowId','INT'),0),
    @criteriaId = ISNULL(ref.value('@criteriaId','INT'),0),
    @userGroupId = ISNULL(ref.value('@userGroupId','INT'),0),
    @userId = ISNULL(ref.value('@userId','INT'),0),
	@shareId = ISNULL(ref.value('@shareId','INT'),0)
FROM @entity.nodes ('CvEntities_GenericEntity') R(ref)
IF ( @clientGroupId = 0 AND @clientId = 0 AND @applicationId = 0 AND
     @instanceId = 0 AND @backupsetId = 0 AND @subclientId = 0 AND
     @mediaAgentId = 0 AND @schedulePolicyId = 0  AND
     @libraryId = 0 AND @storagePolicyId = 0 AND @copyId = 0  AND
     @trackingPolicyId = 0   AND @workflowId = 0 AND @criteriaId = 0 AND
	 @userGroupId = 0 AND @userId = 0 AND @shareId = 0
) AND @alertType!=17 -- MR 290928
   -- Alert for drive failure isnt getting generated because of below condition because mm does sendAlert call for library management
   -- with libraryID as 0 and its getting filtered below. In v9 if alert had all libraries selected then we were matching it.
BEGIN
    --Print ' empty data input returning 0'
    SET @retval = 0
    return @retval
END
IF (@subclientId=-1) -- JM sends subclientId as -1 for data recovery alerts.
BEGIN
	SET @subclientId = 0
END
----------- fixing the mr --- setting instanceId if not given -----
IF ( @subclientId <> 0 and (@backupsetId = 0 OR @instanceId = 0 OR @applicationId = 0) )
  begin
     select @backupsetId = backupSet , @instanceId = instance , @applicationId = appTypeId
     from APP_Application  with (nolock)
     where id = @subclientId
  end
------------------------------
--check if the notification belongs to the alert type that needs appTypeFilter check
 SELECT @actionsAllowed=actionsAllowed FROM NTAlertType
					 WHERE id=(SELECT alertTypeId FROM NTnotificationRule WITH (NOLOCK) WHERE id= @alertId )
  -- do apptype check only if alert has apptypefilter support
  -- there could be non idatype entities that doesnot have any apptype associated like sp, spcopy, donot filter them out here
  -- filter only when we have client or apptype id
IF(@actionsAllowed & 16 <> 0)AND(@clientId > 0 OR @applicationId > 0)
   BEGIN
	IF EXISTS (SELECT 1 from NTnotificationProp WITH (NOLOCK)
WHERE componentNameId=@alertId and attrName in ('App Type Filter','App Group Filter') )--check if appTypefilter property is found in NTNotificationProp(no such prop in table implies all apptypes selected)
		BEGIN--if found, check if entity belongs to the filter
			-- If entity has apptype check whether the appType is part of app type/appgroup filter.
			-- if the entity doesnt have appType and it has client, then apptype installed on client should be part of apptype/appgroup filter.
			IF NOT EXISTS( SELECT 1 FROM NTnotificationProp WITH (NOLOCK)
WHERE @applicationId>0 AND componentNameId=@alertId AND attrName='App Type Filter' AND attrVal=cast(@applicationId as nvarchar(10))
					union
					SELECT 1 FROM APP_AppTypeGroupAssoc WITH (NOLOCK) inner join NTnotificationProp WITH (NOLOCK) on
@applicationId>0 AND componentNameId=@alertId and attrName='App Group Filter' ANd cast(AppGroupId as nvarchar(10))=attrVal
					AND appTypeId=@applicationId AND typeOfGroup=0
					union
					SELECT 1 FROM NTnotificationProp WITH (NOLOCK)
					Inner join APP_IDAName on @applicationId=0 AND @clientId>0 AND APP_IDAName.clientId = @clientId AND componentNameId=@alertId
AND attrName='App Type Filter' AND attrVal=cast(APP_IDAName.appTypeId as nvarchar(10))
					union
					SELECT 1 FROM APP_AppTypeGroupAssoc WITH (NOLOCK) inner join NTnotificationProp WITH (NOLOCK) on
@applicationId=0 AND @clientId>0 AND componentNameId=@alertId and attrName='App Group Filter' ANd cast(AppGroupId as nvarchar(10))=attrVal
					inner join App_idaname on App_idaname.clientId = @clientId
					AND APP_AppTypeGroupAssoc.appTypeId=App_idaname.appTypeId AND typeOfGroup=0
					)--check if entity belongs to any appGroup selected
				BEGIN
					set @retval=0
					return @retval
				END
		END
  END
IF ( @userGroupId <> 0 )
BEGIN
	IF( (SELECT COUNT(*) FROM UMGroups WITH (NOLOCK)
		WHERE id = @userGroupId AND umdsProviderId <> 0) > 0)
	BEGIN
		--PRINT 'Entity Assocoation to Alert for External User Group is not supported now'
		SET @retval = 0
		return @retval
	END
END
IS_ASSOCIATED:
------------------------------
IF ( @clientid <> 0)
BEGIN
    IF(  ( SELECT COUNT(*) FROM @EntityListTableTemp AS ELIST
           JOIN APP_ClientGroupAssoc AS CGROUPASSOC WITH ( NOLOCK )
           ON ELIST.clientGroupId = CGROUPASSOC.clientGroupId
           WHERE CGROUPASSOC.clientid = @clientId AND exclude = 1  AND (ELIST.clientId=0 OR ELIST.clientId=@clientId) ) > 0
       )
    BEGIN
            --PRINT 'Client group is excluded '
            SET @retval = 0
            return @retval
    END
END
IF ( @userId <> 0)
BEGIN
    IF(  ( SELECT COUNT(*) FROM @EntityListTableTemp AS ELIST
           JOIN UMUserGroup AS USERGROUPASSOC WITH ( NOLOCK )
           ON ELIST.userGroupId = USERGROUPASSOC.groupId
           WHERE USERGROUPASSOC.userId = @userId AND exclude = 1  AND (ELIST.userId=0 OR ELIST.userId=@userId) ) > 0
       )
    BEGIN
            --PRINT 'User group is excluded '
            SET @retval = 0
            return @retval
    END
END
IF (
    ( SELECT COUNT(*) FROM @EntityListTableTemp
      WHERE
        (
            (mediaAgentId = @mediaAgentId OR mediaAgentId = 0 ) AND
            (libraryId = @libraryId OR libraryId = 0  ) AND
            (criteriaId = @criteriaId OR criteriaId = 0 ) AND
            (schedulePolicyId = @schedulePolicyId OR schedulePolicyId = 0 )AND
            ((storagePolicyId = @storagePolicyId OR storagePolicyId = 0 ) AND
             (copyId = @copyId OR  copyId= 0 ))AND
            (trackingPolicyId = @trackingPolicyId OR trackingPolicyId = 0 ) AND
            (workflowId = @workflowId OR workflowId = 0 ) AND
            (clientGroupId = @clientgroupid OR clientgroupid = 0 ) AND
            ((clientId = @clientId OR  clientId = 0 ) AND
             (applicationId = @applicationId OR applicationId = 0 ) AND
             (instanceId = @instanceId OR  instanceId = 0 ) AND
             (backupsetId = @backupsetId OR  backupsetId = 0) AND
             (subclientId = @subclientId OR  subclientId = 0 )) AND
            (userGroupId = @userGroupId OR userGroupId = 0 ) AND
            (userId = @userId OR userId = 0 ) AND
			(shareId = @shareId OR shareId = 0) AND
            exclude = 1
        )
    ) > 0
   )
BEGIN
        --print 'FOUND IN EXCLUDED LIST'
        SET @retval = 0
        return @retval
END
IF (  ( SELECT COUNT(*) FROM @EntityListTableTemp
        WHERE  clientGroupId = 0 AND clientId = 0 AND applicationId = 0
              AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
              AND mediaAgentId = 0 AND schedulePolicyId = 0
              AND libraryId = 0 AND storagePolicyId = 0 AND copyId = 0
              AND trackingPolicyId = 0 AND  workflowId = 0
              AND criteriaId = 0 AND userGroupId = 0 AND userId = 0
			  AND SHAREID = 0
              AND _type_ <> 27 AND _type_ <> 14) >0
    )
BEGIN
        --print 'All Entities are included'
        SET @retval = 1
        return @retval
END
IF( @clientId <> 0 )
BEGIN
  IF (
        ( SELECT COUNT(*) FROM @EntityListTableTemp
        WHERE  _type_ = 27 ) >0
     )
  BEGIN
        IF (  ( ( SELECT COUNT(*) FROM APP_ClientGroupAssoc WITH (NOLOCK)
                 WHERE clientId = @clientId  ) >0 )
           )
        BEGIN
        --  PRINT 'ALL_CLIENT_GROUPS_ENTITY inluded and entity is client inside some clientgroup or entity is a valid client group'
            SET @retval = 1
            return @retval
        END
  END
END
IF( @userId <> 0 )
BEGIN
  IF (
        ( SELECT COUNT(*) FROM @EntityListTableTemp
        WHERE  _type_ = 14 ) >0
     )
  BEGIN
        IF (  ( ( SELECT COUNT(*) FROM UMUserGroup AS USERGROUPASSOC WITH (NOLOCK)
					INNER JOIN UMGroups AS USERGROUP WITH (NOLOCK)
					ON USERGROUPASSOC.groupId = USERGROUP.id
					WHERE USERGROUPASSOC.userId = @userId AND USERGROUP.umdsProviderId = 0  ) >0 )
           )
        BEGIN
        --  PRINT 'USERGROUPS_ENTITY inluded and entity is user inside some user group which is not an external group'
            SET @retval = 1
            return @retval
        END
  END
END
IF( ( SELECT COUNT(*) FROM @EntityListTableTemp
      WHERE
        (
            (mediaAgentId = @mediaAgentId OR mediaAgentId = 0 ) AND
            (libraryId = @libraryId OR libraryId = 0 )  AND
            (criteriaId = @criteriaId OR criteriaId = 0 ) AND
            (schedulePolicyId = @schedulePolicyId OR schedulePolicyId = 0 )AND
            ((storagePolicyId = @storagePolicyId OR storagePolicyId = 0 ) AND
             (copyId = @copyId OR copyId = 0 ))AND
            (trackingPolicyId = @trackingPolicyId OR trackingPolicyId = 0 ) AND
            (workflowId = @workflowId OR workflowId = 0 ) AND
            (clientGroupId = @clientgroupid OR clientgroupid = 0  ) AND
            ((clientId = @clientId OR (clientId = 0 AND _type_ <> 27) ) AND --if @clientId <> 0 then client should not be included in all client groups as client might not be part of any client group and that case is already handled
             (applicationId = @applicationId OR applicationId = 0 ) AND
             (instanceId = @instanceId OR instanceId = 0 ) AND
             (backupsetId = @backupsetId OR  backupsetId = 0) AND
             (subclientId = @subclientId OR  subclientId = 0 OR (@alertType=4 AND @subclientId=0) )) AND -- For restore alerts entity selection is supported till subclient level. But sometimes JM doesnt send subclientId.
            (userGroupId = @userGroupId OR userGroupId = 0 ) AND
			(shareId = @shareId OR shareId = 0 ) AND
            (userId = @userId OR (userId = 0 AND _type_ <> 14 ) ) --if @userId <> 0 then user should not be included in all user groups as user might not be part of any user group and that case is already handled
        )
    ) > 0
   )
BEGIN
        --print 'FOUND IN included LIST'
        SET @retval = 1
        return @retval
END
IF ( @clientid <> 0)
BEGIN
    IF(  ( SELECT COUNT(*) FROM @EntityListTableTemp AS ELIST
           JOIN APP_ClientGroupAssoc AS CGROUPASSOC WITH ( NOLOCK )
           ON ELIST.clientGroupId = CGROUPASSOC.clientGroupId
           WHERE CGROUPASSOC.clientid = @clientId AND (ELIST.clientId=0 OR ELIST.clientId=@clientId) ) > 0
       )
    BEGIN
        --  PRINT 'Client group is included and client is part of it'
            SET @retval = 1
            return @retval
    END
END
IF ( @userId <> 0)
BEGIN
    IF(  ( SELECT COUNT(*) FROM @EntityListTableTemp AS ELIST
           JOIN UMUserGroup AS USERGROUPASSOC WITH ( NOLOCK )
           ON ELIST.userGroupId = USERGROUPASSOC.groupId
           WHERE USERGROUPASSOC.userId = @userId  AND (ELIST.userId=0 OR ELIST.userId=@userId) ) > 0
       )
    BEGIN
            --PRINT 'User group is included and user is part of it'
            SET @retval = 1
            return @retval
    END
END
BEGIN
        --print'Entity is not present in excluded or included list so return 0'
        SET @retval = 0
        return @retval
END
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsEntityInAssocList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsEntityInAssocList' AND revision = '1.3.14.12')

  insert into GXDBVersions values(5, 'IsEntityInAssocList',  '1.3.14.12', 'IsEntityInAssocList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
