

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsDistributedClusterTypePresent.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsDistributedClusterTypePresent'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsDistributedClusterTypePresent]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsDistributedClusterTypePresent]
  delete from GXDBVersions where name = 'IsDistributedClusterTypePresent' and type = 5
END
GO

	CREATE FUNCTION IsDistributedClusterTypePresent(@i_clientId integer, @i_clusterTypeId integer)
	RETURNS INT
	AS
	BEGIN
		DECLARE @isDistributedClusterTypePresent INT = 0
		IF EXISTS (SELECT TOP 1 I.componentNameId
					FROM APP_InstanceProp I (NOLOCK)
					JOIN APP_Application S (NOLOCK) ON I.componentNameId = S.instance AND S.ClientId = @i_clientId
					WHERE I.attrname = 'Distributed Cluster Type' AND I.modified = 0 AND CAST (I.attrVal AS INT) = @i_clusterTypeId
				)
			SET @isDistributedClusterTypePresent = 1

		RETURN @isDistributedClusterTypePresent
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsDistributedClusterTypePresent]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsDistributedClusterTypePresent' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'IsDistributedClusterTypePresent',  '1.1.2.1', 'IsDistributedClusterTypePresent', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
