

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsDeferredCatalogSupported.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsDeferredCatalogSupported'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsDeferredCatalogSupported]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsDeferredCatalogSupported]
  delete from GXDBVersions where name = 'IsDeferredCatalogSupported' and type = 5
END
GO

		CREATE FUNCTION IsDeferredCatalogSupported (@i_appId INT)
		RETURNS INT
		AS
		BEGIN
			DECLARE @retVal int
			IF EXISTS
			(
			SELECT 1 FROM App_Application APP WITH(NOLOCK) INNER JOIN App_Client CL WITH(NOLOCK) ON APP.clientId = CL.id
														   LEFT OUTER JOIN MMNDMPHostInfo MMNDMP WITH(NOLOCK) ON MMNDMP.ClientId = CL.id
			WHERE APP.id = @i_appId AND ((CL.simOperatingSystemId = 16 OR
										  CL.simOperatingSystemId = 17 OR
 										  CL.simOperatingSystemId = 29 OR
 										  MMNDMP.OSType = 32 OR
										  APP.appTypeId <> 13) AND APP.appTypeId IN(select appTypeId from dbo.GetDeferredCatalogSupportedAppTypes()))
			)
				SET @retVal = 1
			ELSE
				SET @retVal = 0

			RETURN @retVal

		END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsDeferredCatalogSupported]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsDeferredCatalogSupported' AND revision = '1.2.32.5')

  insert into GXDBVersions values(5, 'IsDeferredCatalogSupported',  '1.2.32.5', 'IsDeferredCatalogSupported', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
