

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsContainerExists.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsContainerExists'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsContainerExists]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsContainerExists]
  delete from GXDBVersions where name = 'IsContainerExists' and type = 5
END
GO

	CREATE FUNCTION IsContainerExists(@userId int, @containerType int, @containerName NVARCHAR(MAX))
	RETURNS @Results TABLE
	(
		containerId INTEGER NOT NULL,
		containerGuid VARCHAR(512) NOT NULL
	)
	    AS
	    BEGIN
			DECLARE @containerId INT = 0
			DECLARE @containerGuid VARCHAR(512) = ''
	        DECLARE @containers TABLE (entityId int, entityType int, containerGuid varchar(512))
	        DECLARE @users TABLE (containerId int, containerGuid varchar(512), userOrGroupId int, isUser bit)
	        INSERT INTO @containers
	        SELECT containerId, containerType, containerGuid FROM DM2Container WHERE containerName = @containerName AND containerType = @containerType
	        DECLARE @isCreator INT =0
	        DECLARE @userGRoupORUSerId INT=0
	        INSERT INTO @users
	        SELECT C.entityId, C.containerGuid, US.userOrGRoupId , US.isUser FROM UMSecurityAssociations US WITH(NOLOCK) INNER JOIN @containers C on US.entityId1=C.entityId and US.entityType1 = C.entityType WHERE US.isCreator=1 GROUP BY userOrGroupId, isUser, C.entityId, C.containerGuid
			SELECT TOP 1 @containerId=containerId, @containerGuid=containerGuid FROM @users WHERE isUser = 1 and userOrGroupId = @userId
	        IF @containerId > 0
	        BEGIN
	            INSERT INTO @Results
				SELECT @containerId, @containerGuid
				RETURN
	        END
	        ELSE
	        BEGIN
					SELECT TOP 1 @containerId=US.containerId, @containerGuid=US.containerGuid FROM UMGroups UG WITH(NOLOCK), @users US where US.isUser=0 and US.userOrGroupId=id  AND UG.groupFlags & 1 = 1
	                IF @containerId > 0
	                BEGIN
						SELECT TOP 1 @containerId=US.containerId, @containerGuid=US.containerGuid from  UMUserGroup UG WITH(NOLOCK), @users US  WHERE US.isUser=0 and UG.groupId=US.userOrGroupId and UG.userId=@userId
	                    IF @containerId > 0
						BEGIN
							INSERT INTO @Results
							SELECT @containerId, @containerGuid
							RETURN
						END
						SELECT TOP 1 @containerId=US.containerId, @containerGuid=US.containerGuid FROM  UMDSGroupMaps GM  WITH(NOLOCK) INNER JOIN UMUserGroup UG WITH(NOLOCK) ON UG.groupId = GM.umDSgroupId
	                            INNER JOIN @users US ON US.isUser=0 and US.userOrGroupId = GM.umgroupId
	                            WHERE UG.userId = @userId
	                    IF @containerId > 0
						BEGIN
							INSERT INTO @Results
							SELECT @containerId, @containerGuid
							RETURN
						END
	                END
	        END
			INSERT INTO @Results
			SELECT 0, ''
	        RETURN
	    END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsContainerExists]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsContainerExists' AND revision = '1.1.4.2')

  insert into GXDBVersions values(5, 'IsContainerExists',  '1.1.4.2', 'IsContainerExists', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
