

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsClientSnapEnabled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsClientSnapEnabled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsClientSnapEnabled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsClientSnapEnabled]
  delete from GXDBVersions where name = 'IsClientSnapEnabled' and type = 5
END
GO

	CREATE FUNCTION IsClientSnapEnabled(@clientId integer)
	RETURNS VARCHAR(100)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result VARCHAR(100) = 'No'
		DECLARE @snapEnabled INT = ISNULL((SELECT CAST(attrVal AS INT) from APP_ClientProp where componentNameId = @clientId and attrName = 'Snap Backups Enabled' and modified = 0),0)
		IF @snapEnabled = 1
		BEGIN
			SET @result='Yes'
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsClientSnapEnabled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsClientSnapEnabled' AND revision = '1.2.208.1')

  insert into GXDBVersions values(5, 'IsClientSnapEnabled',  '1.2.208.1', 'IsClientSnapEnabled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
