

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsCCSSoftwareUsageValidForClient.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: IsCCSSoftwareUsageValidForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsCCSSoftwareUsageValidForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsCCSSoftwareUsageValidForClient]
  delete from GXDBVersions where name = 'IsCCSSoftwareUsageValidForClient' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION IsCCSSoftwareUsageValidForClient(@inClientId INT)
RETURNS  @ClientCfg TABLE (clientId INT PRIMARY KEY, ccsEnabled TINYINT NULL, spVersion INT NOT NULL)
AS
BEGIN
	INSERT INTO @ClientCfg (clientId, ccsEnabled, spVersion)
		SELECT
			q.clientId,
			q.ccsEnabled,
			q.GESP12Version spVersion
		FROM ClientsWithValidCCSCfgsView q
		WHERE
			q.clientId = @inClientId
			AND q.GESP12Version >= 14		-- V11 SP14+ required for CCS Software support
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsCCSSoftwareUsageValidForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsCCSSoftwareUsageValidForClient' AND revision = '1.1.4.4.36.1')

  insert into GXDBVersions values(5, 'IsCCSSoftwareUsageValidForClient',  '1.1.4.4.36.1', 'IsCCSSoftwareUsageValidForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
