

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsAppTypeInNTAppTypeFilter.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: IsAppTypeInNTAppTypeFilter'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsAppTypeInNTAppTypeFilter]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsAppTypeInNTAppTypeFilter]
  delete from GXDBVersions where name = 'IsAppTypeInNTAppTypeFilter' and type = 5
END
GO

CREATE FUNCTION IsAppTypeInNTAppTypeFilter (@alertId INT, @appTypeId int)
RETURNS INTEGER
AS
BEGIN
DECLARE @actionsAllowed INT
--check if the notification belongs to the alert type that needs appTypeFilter check
 SELECT @actionsAllowed=actionsAllowed FROM NTAlertType
		inner join NTnotificationRule WITH (readuncommitted) on
		NTnotificationRule.alertTypeId = NTAlertType.id
		and NTnotificationRule.id = @alertId
 IF(@appTypeId=0)--do apptype check only if entity is associated with some appType
 begin
	return 0
 end
IF(@actionsAllowed & 16 <> 0)--do apptype check only if alert has apptypefilter support
   BEGIN
		IF EXISTS (SELECT 1 from NTnotificationProp WITH (readuncommitted)
WHERE componentNameId=@alertId and attrName in ('App Type Filter','App Group Filter') )--check if appTypefilter property is found in NTNotificationProp(no such prop in table implies all apptypes selected)
		BEGIN--if found, check if entity belongs to the filter
			IF EXISTS( SELECT 1 FROM NTnotificationProp WITH (readuncommitted)
WHERE componentNameId=@alertId AND attrName='App Type Filter' AND attrVal=cast(@appTypeId as nvarchar(10)))
			begin
				return 1
            end
			IF EXISTS( SELECT 1 FROM APP_AppTypeGroupAssoc WITH (readuncommitted)
WHERE AppGroupId in (select attrVal from NTnotificationProp WITH (readuncommitted) where componentNameId=@alertId and attrName='App Group Filter')
					AND appTypeId=@appTypeId AND typeOfGroup=0)--check if entity belongs to any appGroup selected
			begin
				return 1
            end
			return 0
		END
		-- If alert doesnt have any apptype filters then all apptypes are allowed.
		return 1
  END
  -- If alert type doesnt support filters, then all apptypes are allowed.
  return 1
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsAppTypeInNTAppTypeFilter]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsAppTypeInNTAppTypeFilter' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'IsAppTypeInNTAppTypeFilter',  '1.1.2.4', 'IsAppTypeInNTAppTypeFilter', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
