

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetYearMonthNumberOfWeeks.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: GetYearMonthNumberOfWeeks'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetYearMonthNumberOfWeeks]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetYearMonthNumberOfWeeks]
  delete from GXDBVersions where name = 'GetYearMonthNumberOfWeeks' and type = 5
END
GO

	CREATE FUNCTION GetYearMonthNumberOfWeeks(@year SMALLINT)
	RETURNS @YearMonthNumberOfWeeks TABLE (
	    yearNo          SMALLINT,
	    monthNo         TINYINT,
	    numberOfWeeks   TINYINT,
	    PRIMARY KEY (yearNo, monthNo)
	)
	AS
	BEGIN
	    ;WITH Weeks
	    AS
	    (
	        SELECT
	            Number + 1 as mth,
	            DATEDIFF(DAY, -1, DATEADD(MONTH,((@year - 1900) *12)+ number, 0)) / 7 AS fst, DATEDIFF(DAY, -1, DATEADD(MONTH,((@year - 1900) * 12)+ number, 30)) / 7  AS lst
	        FROM SequenceNumbers
	        WHERE
	            number < 12
	    )
	        INSERT INTO @YearMonthNumberOfWeeks
	            SELECT
	                @year [yearNo],
	                mth [monthNo],
	                (lst - fst) + 1 [numberOfWeeks]
	            FROM Weeks;

	RETURN;


	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetYearMonthNumberOfWeeks]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetYearMonthNumberOfWeeks' AND revision = '')

  insert into GXDBVersions values(5, 'GetYearMonthNumberOfWeeks',  '', 'GetYearMonthNumberOfWeeks', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
