

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetXMLJobOptions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetXMLJobOptions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetXMLJobOptions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetXMLJobOptions]
  delete from GXDBVersions where name = 'GetXMLJobOptions' and type = 5
END
GO

	CREATE FUNCTION GetXMLJobOptions(@jobId bigint)
	RETURNS XML
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @xmlText	XML
		DECLARE @refTime	INT
		SELECT TOP 1 @taskId=[taskId], @subTaskId=[subTaskId], @refTime=[created] FROM TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE [jobId]=@jobId)
		--GET THE LIST OF OPTION VALUES FROM THE TM_JOBXMLOPTIONS TABLE
		SET @xmlText =
		(
				SELECT xmlValue FROM TM_JobXMLOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId)
				UNION ALL		--ONLY ONE QUERY WILL RETURN OUTPUT BUT UNION ALL IS NEEDED BECAUSE XML CANNOT BE DISTINCT
				SELECT xmlValue FROM TM_JobXMLOptions AS TJ WITH (READUNCOMMITTED) WHERE (
					(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime))
				) AND
				NOT EXISTS(SELECT * FROM TM_JobXMLOptions AS LT WITH (READUNCOMMITTED) WHERE (jobId=@jobId))
		)
		RETURN @xmlText
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetXMLJobOptions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetXMLJobOptions' AND revision = '1.10.186.1')

  insert into GXDBVersions values(5, 'GetXMLJobOptions',  '1.10.186.1', 'GetXMLJobOptions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
