

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetWorkflowStatusName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetWorkflowStatusName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetWorkflowStatusName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetWorkflowStatusName]
  delete from GXDBVersions where name = 'GetWorkflowStatusName' and type = 5
END
GO

	CREATE FUNCTION GetWorkflowStatusName (@Status int)
	RETURNS nvarchar(255)
	AS
	BEGIN
		DECLARE @statusName varchar(255)
		SELECT @statusName =
			CASE @Status
			WHEN 0 THEN 'Idle'
			WHEN 1 THEN 'Queued'
			WHEN 2 THEN 'Running'
			WHEN 3 THEN 'Suspended'
			WHEN 4 THEN 'Success'
			WHEN 5 THEN 'Error'
			WHEN 6 THEN 'Failed'
			ELSE 'Unknown' END
		RETURN @statusName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetWorkflowStatusName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetWorkflowStatusName' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetWorkflowStatusName',  '1.1', 'GetWorkflowStatusName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
