

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetWeekStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetWeekStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetWeekStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetWeekStart]
  delete from GXDBVersions where name = 'GetWeekStart' and type = 5
END
GO

	CREATE FUNCTION GetWeekStart (@DateArg DATETIME, @DayStartOffset int)
	RETURNS DATETIME
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE	@CurrentTime	DATETIME
		SET @CurrentTime = DATEADD(second, -@DayStartOffset, @DateArg)
		DECLARE @wkDay integer
		SET @wkDay = (SELECT CASE DATEPART(WEEKDAY, @CurrentTime)
				WHEN 1 THEN 8
				ELSE datepart(WEEKDAY, @CurrentTime)
				END )
		RETURN dbo.GetDateTime(dbo.GetUnixTime(dbo.GetDayStart(@CurrentTime, @DayStartOffset)) - ((@wkDay - 2) * 3600 * 24))
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetWeekStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetWeekStart' AND revision = '1.2.304.1')

  insert into GXDBVersions values(5, 'GetWeekStart',  '1.2.304.1', 'GetWeekStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
