

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetWeekOfDate.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetWeekOfDate'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetWeekOfDate]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetWeekOfDate]
  delete from GXDBVersions where name = 'GetWeekOfDate' and type = 5
END
GO

        CREATE FUNCTION GetWeekOfDate
        (
            @i_Date     DATE
        )
        RETURNS @weekPartTbl TABLE (weekNumber INTEGER, isLastWeek INTEGER)
        AS
        BEGIN
        	DECLARE @iMonthCalender TABLE ( calDate DATE, calWeek INT, calIsLastWeek INT DEFAULT 0)
        	DECLARE @StartDate DATE, @EndDate DATE, @in_Date DATE
        	SET @in_Date = @i_Date
        	SELECT @StartDate = dateadd(mm, datediff(mm, 0, @in_Date), 0)
        	SELECT @EndDate = dateadd(mm, datediff(mm, 0, @in_Date) + 1, -1)
        	;WITH e1(n) AS
        	(
        		SELECT 1 FROM (VALUES (1),(2),(3),(4),(5),(6)) t(n)
        	)
        	INSERT @iMonthCalender(calDate, calWeek)
        		SELECT TOP 31
        			DATEADD(DD, N - 1, @StartDate),
        			CASE ((DATEPART(WW, DATEADD(DD, N - 1, @StartDate)) - DATEPART(WW, DATEADD(DD, 0, @StartDate))) + 1)
        				WHEN 1 THEN 1
        				WHEN 2 THEN 2
        				WHEN 3 THEN 4
        				WHEN 4 THEN 8
        				WHEN 5 THEN 16
        			END
        		FROM( SELECT ROW_NUMBER() OVER (ORDER BY (SELECT NULL)) AS n
        		FROM e1 n6
        		CROSS JOIN e1 n36) T
        		WHERE
        			DATEADD(DD, N - 1, @StartDate) <= @EndDate
        		AND
        			DATEADD(DD, N - 1, @StartDate) >= @StartDate
        	UPDATE @iMonthCalender
        		SET calIsLastWeek = 1
        	WHERE
        		calWeek = (SELECT MAX(calWeek) FROM @iMonthCalender)
			INSERT INTO @weekPartTbl(weekNumber, isLastWeek)
			SELECT calWeek, calIsLastWeek FROM @iMonthCalender WHERE calDate = @in_Date
        RETURN;
        END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetWeekOfDate]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetWeekOfDate' AND revision = '')

  insert into GXDBVersions values(5, 'GetWeekOfDate',  '', 'GetWeekOfDate', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
