

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetVMInstanceTypeDesc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetVMInstanceTypeDesc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetVMInstanceTypeDesc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetVMInstanceTypeDesc]
  delete from GXDBVersions where name = 'GetVMInstanceTypeDesc' and type = 5
END
GO

	CREATE FUNCTION GetVMInstanceTypeDesc(@instanceName nvarchar(64))
	RETURNS NVARCHAR(256)
	AS
	BEGIN
		DECLARE @newGenInstName NVARCHAR(64)
		DECLARE @resultInstType NVARCHAR(256)
		SET @newGenInstName = (
			CASE WHEN @instanceName = 'ExtraSmall'
					THEN 'A0'
				WHEN @instanceName = 'Small'
					THEN 'A1'
				WHEN @instanceName = 'Medium'
					THEN 'A2'
				WHEN @instanceName = 'Large'
					THEN 'A3'
				WHEN @instanceName = 'ExtraLarge'
					THEN 'A4'
				WHEN @instanceName = 'Standard_D1'
					THEN 'D1'
				WHEN @instanceName = 'Standard_D2'
					THEN 'D2'
				WHEN @instanceName = 'Standard_D3'
					THEN 'D3'
				WHEN @instanceName = 'Standard_D4'
					THEN 'D4'
				WHEN @instanceName = 'Standard_D11'
					THEN 'D11'
				WHEN @instanceName = 'Standard_D12'
					THEN 'D12'
				WHEN @instanceName = 'Standard_D13'
					THEN 'D13'
				WHEN @instanceName = 'Standard_D14'
					THEN 'D14'
				ELSE @instanceName
			END)
		SELECT	@resultInstType = instanceType +
				CASE WHEN flags in (0,3) THEN '' ELSE ' (' + CASE WHEN cpuCores = 0 THEN 'Shared' ELSE CAST(cpuCores AS VARCHAR(8)) END + ' core(s) ' + memory + ' GB memory)' END
		FROM	App_VMInstanceTypes
		WHERE	instanceType = @newGenInstName
		OR  RIGHT(instanceType, len(@newGenInstName)+2) = '(' + @newGenInstName +')'
        OR  LEFT (instanceType, len(@newGenInstName)+2) = @newGenInstName + ' ['

		RETURN ISNULL(@resultInstType, '')
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetVMInstanceTypeDesc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetVMInstanceTypeDesc' AND revision = '1.4.12.2')

  insert into GXDBVersions values(5, 'GetVMInstanceTypeDesc',  '1.4.12.2', 'GetVMInstanceTypeDesc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
