

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetUserInteractions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUserInteractions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUserInteractions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUserInteractions]
  delete from GXDBVersions where name = 'GetUserInteractions' and type = 5
END
GO

 CREATE FUNCTION [dbo].[GetUserInteractions] (
 	@USER_ID		INTEGER,
 	@ALLOW_ALL		BIT=0
 	)
  RETURNS @Results TABLE (
 	InteractionId	INT PRIMARY KEY
  )
  AS
  BEGIN
 	IF (@ALLOW_ALL = 1)
 	BEGIN
  		DECLARE @isUserAdmin int = 0
  		IF EXISTS ( SELECT UD.userId
  					FROM UMDSUserGroup UD INNER JOIN UMDSGroupMaps GM
  					ON UD.groupId = GM.umDSgroupId
  					WHERE UD.userId = @USER_ID AND GM.umgroupId = 1 )
 		SET @isUserAdmin = 1
  		IF EXISTS (	SELECT id
  					FROM UMUserGroup INNER JOIN UMUsers
  					ON UMUserGroup.userId = UMUsers.id
  					WHERE UMUsers.id = @USER_ID AND UMUserGroup.groupId = 1 )
 		SET @isUserAdmin = 1
  		IF (@isUserAdmin = 1)
  		BEGIN
 			INSERT INTO @Results(InteractionId)
  			SELECT InteractionId
 			FROM WF_Interaction
 			GOTO COMPLETE
		END
  	END

  	INSERT INTO @Results(InteractionId)
  	SELECT InteractionId
  	FROM WF_InteractionUsers
  	WHERE userId = @USER_ID
	union
  	SELECT  InteractionId
  	FROM WF_InteractionUsers
  	WHERE groupId in
  	(
  		SELECT UMGroups.id
  		FROM UMGroups INNER JOIN UMUserGroup ON UMGroups.id = UMUserGroup.groupId
  		WHERE UMUserGroup.userId = @USER_ID
  	)
	union
  	SELECT  InteractionId
  	FROM WF_InteractionUsers
  	WHERE groupId in
  	(
  		SELECT   DISTINCT  UMGroups.id
  		FROM      UMGroups INNER JOIN
  				  UMDSGroupMaps ON UMGroups.id = UMDSGroupMaps.umgroupId INNER JOIN
  				  UMDSUserGroup ON UMDSGroupMaps.umDSgroupId = UMDSUserGroup.groupId
  		WHERE     UMDSUserGroup.userId  = @USER_ID
  	)
	union
  	SELECT  InteractionId
  	FROM WF_InteractionUsers
  	WHERE extGroupId in
  	(
  		SELECT UMDSgroups.id
  		FROM UMDSgroups INNER JOIN UMDSUserGroup ON UMDSgroups.id = UMDSUserGroup.groupId
  		WHERE UMDSUserGroup.userId = @USER_ID
  	)

  	COMPLETE:

  RETURN
  END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUserInteractions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUserInteractions' AND revision = '1.4.86.1')

  insert into GXDBVersions values(5, 'GetUserInteractions',  '1.4.86.1', 'GetUserInteractions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
