

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetUTCToClientLocalTimeInParts.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUTCToClientLocalTimeInParts'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUTCToClientLocalTimeInParts]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUTCToClientLocalTimeInParts]
  delete from GXDBVersions where name = 'GetUTCToClientLocalTimeInParts' and type = 5
END
GO

		CREATE FUNCTION GetUTCToClientLocalTimeInParts
		(
	 		@UTCTimeInt   	INTEGER,
	 		@ClientID		INTEGER
		)
		RETURNS @datePartTbl TABLE (clientTime DATETIME,year INTEGER,month INTEGER, day INTEGER, weekDay INTEGER, hour INTEGER, minute INTEGER, seconds INTEGER, localMidNightEpoch INTEGER )
		AS
		BEGIN
		-- Logic is same as vaultcx/Source/CommServer/Db/Function/UTCToClientLocalTime.func, except return type
		DECLARE @UTCTime   DATETIME
		SET @UTCTime =  dbo.GetDateTime(@UTCTimeInt)
    	DECLARE @attrv			VARCHAR(255)
		DECLARE @month			INTEGER
		DECLARE @weekday		INTEGER
		DECLARE @hour			INTEGER
		DECLARE @minute			INTEGER
		DECLARE @second			INTEGER
		DECLARE @year			INTEGER
		DECLARE @day			INTEGER
		DECLARE @localTime		DATETIME
        DECLARE @timeZoneName	VARCHAR(255)
		DECLARE @CHAR			INTEGER
		DECLARE @count			INTEGER
		DECLARE @length			INTEGER
		DECLARE @position		INTEGER
        DECLARE @MidNightEpoch	INTEGER = 0
		SELECT @attrv = TimeZoneStdName FROM SchedTimeZone(NOLOCK) WHERE TimeZoneID = ISNULL((select TOP 1 CAST(attrVal as int) FROM APP_ClientProp(NOLOCK) WHERE componentNameId = @ClientID AND attrName = 'timezone Id' and modified = 0), 0)

 		IF @attrv IS NULL
		BEGIN
			SELECT TOP 1 @attrv = attrVal  FROM APP_ClientProp WITH (READUNCOMMITTED) WHERE componentNameId = @ClientID AND attrName = 'timezone' AND modified = 0

			IF (@attrv IS NULL)
			BEGIN
				SELECT TOP 1 @attrv = attrVal  FROM APP_ClientProp WITH (READUNCOMMITTED) WHERE componentNameId = 2 AND attrName = 'timezone' AND modified = 0
			END -- Assuming above query will never return NULL.

			SET @CHAR = 1
			SET @count = 1
			SET @length = DATALENGTH(@attrv)
			SET @position = @length
			WHILE (@position > 0 AND  @CHAR <> 58)
			BEGIN
				SET @CHAR = ASCII(SUBSTRING(@attrv, @position, 1))
				SET @position = @position - 1
			END
			SET @timeZoneName =  RIGHT(@attrv,@length - @position-1)
		END
		ELSE
			SET @timeZoneName =  @attrv
		SET @timeZoneName = LTRIM(RTRIM(@timeZoneName))

		SET @LocalTime = dbo.UTCToLocalTime(@UTCTime , @timeZoneName) -- SQL CLR function, Not worrying about @timeZoneName being NULL or empty, in case of exception CS localtime will be returned

		SET @year = ISNULL(DATEPART(year, @localTime),0)
		SET @month = ISNULL(DATEPART(month, @localTime),0)
		SET @day = ISNULL(DATEPART(day, @localTime),0)
		SET @weekday = ISNULL(DATEPART(weekday, @localTime),0)
		SET @hour = ISNULL(DATEPART(hour, @localTime),0)
		SET @minute = ISNULL(DATEPART(minute, @localTime),0)
		SET @second = ISNULL(DATEPART(second, @localTime),0)

		SET @MidNightEpoch = dbo.GetUnixTime(CONVERT(datetime,CONVERT(date,@LocalTime))) - DATEDIFF(second,@UTCTime,@LocalTime)


		INSERT INTO @datePartTbl VALUES(@LocalTime,@year, @month, @day, @weekday, @hour, @minute , @second, @MidNightEpoch)
		RETURN;
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUTCToClientLocalTimeInParts]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUTCToClientLocalTimeInParts' AND revision = '')

  insert into GXDBVersions values(5, 'GetUTCToClientLocalTimeInParts',  '', 'GetUTCToClientLocalTimeInParts', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
