

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetTimeDiff.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: GetTimeDiff'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetTimeDiff]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetTimeDiff]
  delete from GXDBVersions where name = 'GetTimeDiff' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
create function GetTimeDiff
(
    @timestamp2 int,
	@timestamp1 int
)
returns varchar(128)
as
begin
	declare @diffSec int = (@timestamp2-@timestamp1)%60
	declare @diffMin int = ((@timestamp2-@timestamp1)/60)%60
	declare @diffHour int = ((@timestamp2-@timestamp1)/(60*60))%24
	declare @diffDay int = (@timestamp2-@timestamp1)/(60*60*24)
	declare @diffStr varchar(128)=''
	if @diffDay > 0
		set @diffStr = cast(@diffDay as varchar) + iif(@diffDay=1, ' day', ' days')
	if @diffHour > 0
		set @diffStr += iif(len(@diffStr)>0,', ','') + cast(@diffHour as varchar) + iif(@diffHour=1, ' hour' ,' hours')
	if @diffMin > 0
		set @diffStr += iif(len(@diffStr)>0,', ','') + cast(@diffMin as varchar) + iif(@diffMin=1, ' minute' ,' minutes')
	if @diffSec > 0
		set @diffStr += iif(len(@diffStr)>0,', ','') + cast(@diffSec as varchar) + iif(@diffSec=1, ' second',' seconds')
	return @diffStr
end


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetTimeDiff]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetTimeDiff' AND revision = '')

  insert into GXDBVersions values(5, 'GetTimeDiff',  '', 'GetTimeDiff', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
