

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetThroughputString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetThroughputString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetThroughputString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetThroughputString]
  delete from GXDBVersions where name = 'GetThroughputString' and type = 5
END
GO

	CREATE FUNCTION GetThroughputString ( @sizeInByes BIGINT, @timeInsec BIGINT, @unit int )
	RETURNS VARCHAR(128)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @throughput	FLOAT
		DECLARE @dpPos		INT
		DECLARE @throughputStr	VARCHAR(100)
		IF @timeInsec > 0
		BEGIN
			SET @throughput = convert(float, @sizeInByes) / @timeInsec
			IF @unit = 1 -- GB/Hour
				SET @throughput = @throughput * 3600 / (1024 * 1024 * 1024)
			SET @throughputStr = convert(varchar(100), @throughput)
			SET @dpPos = CHARINDEX('.', @throughputStr)
			IF @dpPos > 0
				SET @throughputStr = SUBSTRING(@throughputStr, 1, @dpPos+2)
			IF @unit = 1
				SET @throughputStr = @throughputStr + ' GB/Hr'
			ELSE
				SET @throughputStr = @throughputStr + ' Bytes/sec'
		END
		ELSE
			SET @throughputStr = '0'
		RETURN @throughputStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetThroughputString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetThroughputString' AND revision = '1.1.290.2')

  insert into GXDBVersions values(5, 'GetThroughputString',  '1.1.290.2', 'GetThroughputString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
