

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetTempExtendedRentiontionTransposedTable.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetTempExtendedRentiontionTransposedTable'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetTempExtendedRentiontionTransposedTable]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetTempExtendedRentiontionTransposedTable]
  delete from GXDBVersions where name = 'GetTempExtendedRentiontionTransposedTable' and type = 5
END
GO

     CREATE FUNCTION GetTempExtendedRentiontionTransposedTable ()
     RETURNS @TempExtendedRentiontionTransposedTable TABLE
     (
            Copyid                  INT,
            retentionDays1  INT,
            retentionRule1  INT,
            GraceDays1              INT,
            retentionDays2  INT,
            retentionRule2  INT,
            GraceDays2              INT,
            retentionDays3  INT,
            retentionRule3  INT,
            GraceDays3              INT
     )
     AS
     BEGIN
            WITH TempRuleOrder (Copyid , retentionDays , retentionRule ,GraceDays,ruleOrder)
            AS
            (
                    SELECT                  copyId,
                                                    retentionDays,
                                                    retentionRule,
                                                    CASE WHEN retentionRule & 262144 = 262144 THEN EveryXHours ELSE GraceDays END, /*EXTENDED_HOUR*/
                                                    ruleOrder = CASE retentionRule
                                                                                    WHEN 2          THEN 1 					/*EXTENDED_ALLFULL*/
                                                                                    WHEN 262144 	THEN 2 					/*EXTENDED_HOUR*/
                                                                                    WHEN 524288 	THEN 3 					/*EXTENDED_DAY*/
                                                                                    WHEN 4          THEN 4 					/*EXTENDED_WEEK*/
                                                                                    WHEN 8          THEN 5 					/*EXTENDED_MONTH*/
                                                                                    WHEN 16         THEN 6 					/*EXTENDED_QUARTER*/
                                                                                    WHEN 32         THEN 7 					/*EXTENDED_HALFYEAR*/
                                                                                    WHEN 64         THEN 8 					/*EXTENDED_YEAR*/
                                                                            END

                            FROM archAgingRuleExtended
            ),

            TempMaster(Copyid , retentionDays , retentionRule ,GraceDays , RowNumber )
            AS
            (
                            SELECT      copyId,
                                                    retentionDays,
                                                    retentionRule,
                                                    GraceDays,
                                                    RowNumber = ROW_NUMBER() OVER (Partition by copyId order by  ruleOrder ASC)
                            FROM TempRuleOrder
            ),
            TempRetentionRulesExtended (Copyid , retentionDays1 , retentionRule1 ,GraceDays1 , retentionDays2 , retentionRule2 ,GraceDays2 ,retentionDays3 , retentionRule3 ,GraceDays3)
            AS
            (
                            SELECT  A.Copyid,
                                            A.retentionDays,
                                            A.retentionRule,
                                            A.GraceDays,
                                            ISNULL(B.retentionDays,0),
                                            ISNULL(B.retentionRule,0),
                                            ISNULL(B.GraceDays,0),
                                            ISNULL(C.retentionDays,0),
                                            ISNULL(C.retentionRule,0),
                                            ISNULL(C.GraceDays,0)

                            FROM    		(SELECT * FROM TempMaster WHERE RowNumber = 1) A
                                                    LEFT OUTER JOIN
                                            (SELECT * FROM TempMaster WHERE RowNumber = 2) B
                                                    ON A.Copyid = B.Copyid
                                                    LEFT OUTER JOIN
                                            (SELECT * FROM TempMaster WHERE RowNumber = 3) C
                                                    ON C.Copyid = B.Copyid
            )
            INSERT INTO @TempExtendedRentiontionTransposedTable   (Copyid , retentionDays1 , retentionRule1 ,GraceDays1 , retentionDays2 , retentionRule2 ,GraceDays2 ,retentionDays3 , retentionRule3 ,GraceDays3)
                    SELECT * FROM TempRetentionRulesExtended
            RETURN
     END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetTempExtendedRentiontionTransposedTable]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetTempExtendedRentiontionTransposedTable' AND revision = '')

  insert into GXDBVersions values(5, 'GetTempExtendedRentiontionTransposedTable',  '', 'GetTempExtendedRentiontionTransposedTable', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
