

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetTaskIDForJob.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetTaskIDForJob'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetTaskIDForJob]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetTaskIDForJob]
  delete from GXDBVersions where name = 'GetTaskIDForJob' and type = 5
END
GO

	CREATE FUNCTION GetTaskIDForJob(@JobId bigint)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobCategory	INTEGER
		DECLARE @taskId		INTEGER
		SET @taskId = -1
		SELECT @jobCategory = jobCategory FROM JMJobInfo WHERE jobId = @JobId
		IF(@jobCategory IS NOT NULL)
		BEGIN
			SET @taskId = CASE @jobCategory
			WHEN 1 THEN ISNULL((SELECT bkpTaskID FROM JMJobTaskLink WHERE jobId = @JobId),-1)
			WHEN 2 THEN ISNULL((SELECT rstTaskID FROM JMJobTaskLink WHERE jobId = @JobId),-1)
			ELSE ISNULL((SELECT adminTaskID FROM JMJobTaskLink WHERE jobId = @JobId),-1)
			END
		END
		RETURN @taskId
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetTaskIDForJob]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetTaskIDForJob' AND revision = '1.4.304.1')

  insert into GXDBVersions values(5, 'GetTaskIDForJob',  '1.4.304.1', 'GetTaskIDForJob', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
