

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSubTaskDetails.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSubTaskDetails'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSubTaskDetails]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSubTaskDetails]
  delete from GXDBVersions where name = 'GetSubTaskDetails' and type = 5
END
GO

 SET ANSI_NULLS ON
 GO
 SET QUOTED_IDENTIFIER ON
 GO
 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 GO
	CREATE FUNCTION GetSubTaskDetails(@subTaskId INT, @taskId INT, @level INT)
	RETURNS XML
		AS
		BEGIN
			IF @level = 0 RETURN NULL
			DECLARE @subtaskDetailXML XML =
				(SELECT
					[subTask/@subTaskName] = ST.subTaskName,
					[subTask/@subTaskId] = ST.subTaskId,
					[subTask/@operationType] = ST.operationType,
					[subTask/@flags] = ST.flags,
					[subTask/@subTaskType] = ST.subTaskType,
					[subTask/@subTaskOrder] = ST.subTaskOrder,
					[subTask/subTask/@subtaskName] = ST.subTaskName,
					[subTask/subTask/@subtaskId] = ST.subTaskId,
					[subTask/subTask/@taskId] = ST.taskId,

					(SELECT
						SOPTIONS.xmlValue.value('/TMMsg_JobOption[1]/@workflowJobOptions','NVARCHAR(MAX)') as '@workflowJobOptions',
						SOPTIONS.xmlValue.query('/TMMsg_JobOption/*')

						FROM TM_SubTaskXMLOptions (NOLOCK) SOPTIONS
							WHERE SOPTIONS.subTaskId = ST.subTaskId
					FOR XML PATH('options'), TYPE),

					(SELECT
						[@patternId] = PAT.patternId,
						[@name] = PAT.name,
						[@flags] = PAT.flags,
						[@freq_type] = PAT.freq_type,
						[@freq_interval] = PAT.freq_interval,
						[@freq_relative_interval] = PAT.freq_relative_interval,
						[@freq_recurrence_factor] = PAT.freq_recurrence_factor,
						[@freq_subday_interval] = PAT.freq_subday_interval,
						[@skipOccurence] = PAT.skipOccurence,
						[@skipDayNumber] = PAT.skipDayNumber,
						[@active_start_date] = PAT.local_start_date,
						[@active_start_time] = PAT.active_start_time,
						[@active_end_date] = PAT.local_end_date,
						[@active_end_time] = PAT.active_end_time,
						[@active_end_occurence] = PAT.active_end_occurence,
						[@description] = PAT.description,
						[@freq_restart_interval] = PAT.freq_restart_interval,
						[timeZone/@TimeZoneID] = PAT.tzId,
						[calendar/@calendarId] = PAT.calendarId,
						[calendar/@calendarName] = CAL.name,
						[daysToRun/@onDayNumber] = IIF(PAT.freq_type = 16, PAT.freq_interval, NULL),
						[daysToRun/@week] = IIF(PAT.freq_type = 32, PAT.freq_relative_interval, NULL),
						[daysToRun/@day] = IIF(PAT.freq_type = 32, PAT.freq_interval, NULL),

						(SELECT
							[@week] = 0,
							[@day] = 0,
							[@Sunday] = IIF((PAT.freq_interval & 0x1) = 0x1, 1, NULL),
							[@Monday] = IIF((PAT.freq_interval & 0x2) = 0x2, 1, NULL),
							[@Tuesday] = IIF((PAT.freq_interval & 0x4) = 0x4, 1, NULL),
							[@Wednesday] = IIF((PAT.freq_interval & 0x8) = 0x8, 1, NULL),
							[@Thursday] = IIF((PAT.freq_interval & 0x10) = 0x10, 1, NULL),
							[@Friday] = IIF((PAT.freq_interval & 0x20) = 0x20, 1, NULL),
							[@Saturday] = IIF((PAT.freq_interval & 0x40) = 0x40, 1, NULL)
							WHERE PAT.freq_type IN (8, 2048)
							FOR XML PATH('daysToRun'),TYPE
						),

						(SELECT  --Repeat Pattern
							[@occurrence] = REP.onOccurence,
							[@onDay] = REP.onDay,
							[@repeatOn] = REP.repeatOn,
							[@onDayNumber] = REP.onDayNumber,
							[@exception] = 1,
							[@description] = REP.description

							FROM TM_RepeatPattern (NOLOCK) AS REP
								WHERE REP.patternId = PAT.patternId
						FOR XML PATH('repeatPattern'), TYPE )

						FROM TM_Pattern (NOLOCK) AS PAT
							INNER JOIN TM_PatternAssoc (NOLOCK) PASOC
							ON [PASOC].[patternId] = PAT.[patternId]
								AND [PASOC].subTaskId = ST.subTaskId
							INNER JOIN APP_CustomCalendar (NOLOCK) AS CAL
								ON CAL.id = PAT.calendarId
					FOR XML PATH('pattern'), TYPE)
				FROM TM_SubTask (NOLOCK) ST
					WHERE (@taskId = 0 OR @taskId = ST.taskId)
						AND (@subTaskId = 0 OR @subTaskId = ST.subTaskId)
				FOR XML PATH('subTasks'), TYPE)
			RETURN @subtaskDetailXML
		END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSubTaskDetails]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSubTaskDetails' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'GetSubTaskDetails',  '1.1.2.3', 'GetSubTaskDetails', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
