

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSubClientDetailList.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: GetSubClientDetailList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSubClientDetailList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSubClientDetailList]
  delete from GXDBVersions where name = 'GetSubClientDetailList' and type = 5
END
GO

 SET ANSI_NULLS ON
 GO
 SET QUOTED_IDENTIFIER ON
 GO
 CREATE FUNCTION GetSubClientDetailList(@planId INT, @policyType INT, @subClientPolicyId INT, @level INT)
 RETURNS XML
 AS BEGIN

    DECLARE @attrVal NVARCHAR(MAX)
    DECLARE @fsSubClientPropXML XML = NULL
    DECLARE @fsSubClientContXML XML = NULL

    DECLARE @rv XML = NULL

    IF @level != 0 BEGIN

        -- subclient retentions

        SET @fsSubClientPropXML = ISNULL(CAST(@attrVal AS XML),

                                        (SELECT
                                            (SELECT [@backupSystemStateforFullBkpOnly] = (SELECT attrVal FROM APP_SubclientProp WITH(NOLOCK) WHERE componentNameId = APP.id AND cs_attrName = CHECKSUM(N'System State on Full Backup Only') AND attrName = 'System State on Full Backup Only' AND modified = 0),
    		                                        [@useVSSForSystemState] = (SELECT attrVal FROM APP_SubclientProp WITH(NOLOCK) WHERE componentNameId = APP.id AND cs_attrName = CHECKSUM(N'Use VSS for System State') AND attrName = 'Use VSS for System State' AND modified = 0),
    		                                        [@backupSystemState] = (SELECT attrVal FROM APP_SubclientProp WITH(NOLOCK) WHERE componentNameId = APP.id AND cs_attrName = CHECKSUM(N'System State') AND attrName = 'System State' AND modified = 0),
    		                                        [diskCleanupRules/@enableArchivingWithRules] = (SELECT attrVal FROM APP_SubclientProp WITH(NOLOCK) WHERE componentNameId = APP.id AND cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing') AND attrName = 'Turbo Mode Enable Stubbing' AND modified = 0)
                                             FROM   App_Application APP
                                             WHERE  APP.backupset = @subClientPolicyId
    	                                     FOR    XML PATH('fsSubClientProp'), TYPE)
                                        FOR XML PATH('App_SubClientInfo'), TYPE))

        -- subclient content
        SET @attrVal = dbo.AppPlanGetEntityValue(@planId, 'Subclient content' + ' ' + CAST(@policyType AS CHAR(1)), default)

        IF ISNUMERIC(@attrVal) = 1 BEGIN
            SET @subClientPolicyId = CAST(@attrVal AS INT)
            SET @attrVal = NULL
        END

        SET @fsSubClientContXML = ISNULL(CAST(@attrVal AS XML),

                                        (SELECT
                                            (SELECT [@path] = IIF(type = 1, fileName, NULL),
    		                                        [@includePath] = IIF(type = 2, fileName, NULL),
    		                                        [@excludePath] = IIF(type = 3, fileName, NULL)
    		                                 FROM   APP_ScFilterFile SCF WITH(NOLOCK) INNER JOIN APP_Application APP WITH(NOLOCK) ON SCF.componentNameId = APP.id AND SCF.modified = 0
                                             WHERE  APP.backupset = @subClientPolicyId
    	                                     FOR    XML PATH('content'), TYPE)
                                        FOR XML PATH('App_SubClientInfo'), TYPE))

        SET @rv = (SELECT
                      (SELECT [subClientEntity/@subclientId]   = App.id,
   	                          [subClientEntity/@subclientName] = App.subclientName,

                              (SELECT T.N.query('.') FROM @fsSubClientPropXML.nodes('App_SubClientInfo/fsSubClientProp') AS T(N) ),
                              (SELECT T.N.query('*') FROM @fsSubClientContXML.nodes('App_SubClientInfo') AS T(N)
   	                   ) FOR XML PATH('subClientList'), TYPE)
                   FROM App_Application App WHERE backupset = @subClientPolicyId
                   FOR XML PATH(''), TYPE)
    END

    RETURN @rv
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSubClientDetailList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSubClientDetailList' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'GetSubClientDetailList',  '1.1.2.2', 'GetSubClientDetailList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
