

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetStoragePolicyCopyDetails.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetStoragePolicyCopyDetails'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetStoragePolicyCopyDetails]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetStoragePolicyCopyDetails]
  delete from GXDBVersions where name = 'GetStoragePolicyCopyDetails' and type = 5
END
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
GO
CREATE FUNCTION GetStoragePolicyCopyDetails(@storagePolicyId INT, @level INT)
RETURNS XML
	AS
	BEGIN
DECLARE @storagePolicyCopyXML XML
IF @level = 0
	RETURN @storagePolicyCopyXML
			;WITH extendedRetentionRules AS
			(SELECT copyId, retentionRule, retentionDays, GraceDays, EveryXHours, ROW_NUMBER() OVER (PARTITION BY copyId ORDER BY copyId) AS  RuleNo
				FROM [dbo].[archAgingRuleExtended] WITH(NOLOCK))
			SELECT @storagePolicyCopyXML = (SELECT
					[@copyType] = AGC.type,
					[@isSnapCopy] = AGC.isSnapCopy,
					[@isMirrorCopy] = AGC.isMirrorCopy,
					[@active] = AGC.isActive,
					[@copyPrecedence] = AGC.copy,
					[@isDefault] = (CASE WHEN EXISTS(SELECT 1 FROM archGroup WITH(NOLOCK) WHERE id = @storagePolicyId AND defaultCopy = AGC.id) THEN 1 ELSE 0 END),
					(SELECT TOP 1 CASE
											WHEN LibraryTypeId <> 3 THEN 4 --'Tape'
											WHEN EXISTS(SELECT 1 FROM MMMountPath MP WHERE MP.LibraryId = MMLibrary.LibraryId AND MP.MountPathTypeId = 7) THEN 2 --cloud
											WHEN EXISTS(SELECT 1 FROM MMSDSStoragePool S WHERE S.LibraryId = MMLibrary.LibraryId) THEN 3 --hyperscale
											ELSE 1 --disk
										END
                            FROM    MMLibrary INNER JOIN MMMasterPool  ON MMLibrary.LibraryId      = MMMasterPool.LibraryId
                                              INNER JOIN MMDrivePool            ON MMDrivePool.MasterPoolId = MMMasterPool.MasterPoolId
                                              INNER JOIN MMDataPath             ON MMDataPath.DrivePoolId   = MMDrivePool.DrivePoolId
                            WHERE   MMDataPath.CopyId = AGC.id)  AS '@storageType',
					[StoragePolicyCopy/@copyId] = AGC.id,
					[StoragePolicyCopy/@copyName] = AGC.name,
					[StoragePolicyCopy/@__type__] = 18,
					(SELECT (CASE WHEN AGC.startTime < 0 THEN -1 ELSE AGC.startTime END) as '@time' FOR XML PATH ('startTime'), TYPE),
					(SELECT
						[@libraryId] = MMLibrary.LibraryId,
						[@libraryName] = MMLibrary.AliasName,
						[@__type__] = 9
						FROM MMLibrary WITH(NOLOCK)
							INNER JOIN MMMasterPool WITH(NOLOCK)
								ON MMLibrary.LibraryId = MMMasterPool.LibraryId
							INNER JOIN MMDrivePool WITH(NOLOCK)
								ON MMDrivePool.MasterPoolId = MMMasterPool.MasterPoolId
							INNER JOIN MMDataPath WITH(NOLOCK)
								ON MMDataPath.DrivePoolId = MMDrivePool.DrivePoolId
							WHERE   MMDataPath.CopyId = AGC.id
						FOR XML PATH('library'), TYPE),
					(SELECT
						[@storagePolicyId] = AG2.id,
						[@storagePolicyName] = AG2.name,
						[@__type__] = 17
						FROM archGroup AG2 WITH(NOLOCK)
							INNER JOIN archCopyToGlobalPolicy GP WITH(NOLOCK)
								ON GP.globalPolicyId = AG2.id
								WHERE	((AGC.extendedFlags&(8192) > 0)
 										OR(AGC.dedupeFlags&(134217728) > 0))
                                        AND GP.CopyId = AGC.id
					 FOR XML PATH('useGlobalPolicy'), TYPE),
					(SELECT     AGC3.id                      AS '@copyId',
                                    AGC3.name                    AS '@copyName',
                                    18                          AS '@__type__'
                            FROM    archGroupCopy AGC3 WITH(NOLOCK)
                            WHERE   AGC3.id = AGC.sourceCopyId AND AGC3.id>0
                         FOR XML PATH('sourceCopy'), TYPE),
					(SELECT
						[@storagePolicyId] = AG3.id,
						[@storagePolicyName] = AG3.name,
						[@__type__] = 17
						FROM archGroupCopy AGC3 WITH(NOLOCK)
							INNER JOIN archGroup AG3 WITH(NOLOCK)
								ON AGC3.archGroupId = AG3.id
WHERE AGC3.id IN (SELECT destMediaCopyId FROM archGroupCopy  WHERE id = AGC.id AND (extendedFlags & 2) > 0)
AND (AGC3.extendedFlags & 1) > 0
					 FOR XML PATH('globalAuxCopy'), TYPE),
					(SELECT
						[@drivePoolId] = MMDrivePool.DrivePoolId,
						[@drivePoolName] = MMDrivePool.DrivePoolName,
						[@__type__] = 47
						FROM MMDrivePool WITH(NOLOCK)
							INNER JOIN MMDataPath WITH(NOLOCK)
								ON MMDataPath.DrivePoolId = MMDrivePool.DrivePoolId
						WHERE   MMDataPath.CopyId = AGC.id
					FOR XML PATH('drivePool'), TYPE),
					(SELECT
						[@retainBackupDataForDays] = retentionDays,
						[@retainBackupDataForCycles] = fullCycles,
						[@retainArchiverDataForDays] = archiverRetDays,
						[@jobs] = retentionJobs,
(SELECT CASE WHEN (flags & 128 > 0) THEN 1 ELSE 0 END AS '@jobBasedRetention'
								 FOR XML PATH ('retentionFlags'), TYPE),
						(SELECT
							[@rule] = retentionRule,
							[@endDays] = retentionDays,
							[@graceDays] = GraceDays,
							[@everyXHours] = EveryXHours,
							[@isEnabled] = IIF(retentionRule IS NOT NULL,1,NULL)
							FROM extendedRetentionRules R WITH(NOLOCK)
								WHERE R.copyId = AGC.id AND R.RuleNo = 1
						FOR XML PATH('extendedRetentionRuleOne'), TYPE),
						(SELECT
							[@rule] = retentionRule,
							[@endDays] = retentionDays,
							[@graceDays] = GraceDays,
							[@everyXHours] = EveryXHours,
							[@isEnabled] = IIF(retentionRule IS NOT NULL,1,NULL)
							FROM extendedRetentionRules R WITH(NOLOCK)
							WHERE R.copyId = AGC.id AND R.RuleNo = 2
						FOR XML PATH('extendedRetentionRuleTwo'), TYPE),
						(SELECT
							[@rule] = retentionRule,
							[@endDays] = retentionDays,
							[@graceDays] = GraceDays,
							[@everyXHours] = EveryXHours,
							[@isEnabled] = IIF(retentionRule IS NOT NULL,1,NULL)
							FROM extendedRetentionRules R WITH(NOLOCK)
							WHERE R.copyId = AGC.id AND R.RuleNo = 3
						FOR XML PATH('extendedRetentionRuleThree'), TYPE)
						FROM archAgingRule WITH(NOLOCK)
						WHERE copyId = AGC.id
					FOR XML PATH('retentionRules'), TYPE),
					(SELECT
(CASE WHEN AGC.dedupeFlags&262144 > 0 THEN (SELECT 1 FOR XML PATH ('enableDeduplication'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&524288 > 0 THEN (SELECT 1 FOR XML PATH ('enableClientSideDedup'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&8388608 > 0 THEN (SELECT 1 FOR XML PATH ('enableDASHFull'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&33554432 > 0 THEN (SELECT 1 FOR XML PATH ('pauseAndRecoverCurrentDDB'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&67108864 > 0 THEN (SELECT 1 FOR XML PATH ('automaticallyPauseAndRecoverDDB'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&134217728 > 0 THEN (SELECT 1 FOR XML PATH ('useGlobalDedupStore'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&268435456 > 0 THEN (SELECT 1 FOR XML PATH ('hostGlobalDedupStore'), TYPE) END),
(CASE WHEN AGC.dedupeFlags&1073741824 > 0 THEN (SELECT 1 FOR XML PATH ('enableSourceSideDiskCache'), TYPE) END)
					FOR XML PATH('dedupeFlags'), TYPE),
					(SELECT
(CASE WHEN AGC.extendedFlags&1 > 0 THEN (SELECT 1 FOR XML PATH ('globalAuxCopyPolicy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&2 > 0 THEN (SELECT 1 FOR XML PATH ('useGlobalAuxCopyPolicy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&256 > 0 THEN (SELECT 1 FOR XML PATH ('arrayReplicaCopy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&2048 > 0 THEN (SELECT 1 FOR XML PATH ('overRideGACPRetention'), TYPE) END),
(CASE WHEN AGC.extendedFlags&65536 > 0 THEN (SELECT 1 FOR XML PATH ('overRideGACPEncryption'), TYPE) END),
(CASE WHEN AGC.extendedFlags&524288 > 0 THEN (SELECT 1 FOR XML PATH ('defaultReplicaCopy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&4096 > 0 THEN (SELECT 1 FOR XML PATH ('globalStoragePolicy'), TYPE) END),
(CASE WHEN AGC.extendedFlags&8192 > 0 THEN (SELECT 1 FOR XML PATH ('useGlobalStoragePolicy'), TYPE) END)
					FOR XML PATH('extendedFlags'), TYPE),
					(SELECT
(CASE WHEN ((SEL.type <> 8) AND (SEL.type <> 4) AND (SEL.numPeriod <> 1))
							  THEN (SELECT 16777216 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_ADVANCED 16777216
						 END),
						--CYCLES
(CASE WHEN ((SEL.numPeriod=1) AND (SEL.type=1)) --CVA_SELECT_BY_CYCLE
							  THEN (SELECT 2 FOR XML PATH('selectiveRule'), TYPE) --SELECTIVE_ALLFULL
						END),
						--HOURS
(CASE WHEN ((SEL.type=10) AND (SEL.numPeriod=1)) --CVA_SELECT_BY_HOURS 10 (SEL.type)
							  THEN (SELECT 262144 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_HOUR = 262144
						END),
						--DAYS
(CASE WHEN ((SEL.type=3) AND (SEL.numPeriod=1)) --CVA_SELECT_BY_DAYS 3 (SEL.type)
						   	  THEN (SELECT 524288 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_DAY = 524288
						END),
						--WEEK
(CASE WHEN (SEL.numPeriod=1) AND (SEL.type = 2)			--CVA_SELECT_BY_WEEKDAY 2 (SEL.type)
							  THEN (SELECT 4 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_WEEK = 4
						END),
						--MONTH
(CASE WHEN (SEL.numPeriod=1) AND (SEL.type = 4) THEN (SELECT 8 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_MONTH = 8
WHEN (SEL.numPeriod=3) AND (SEL.type = 4) THEN (SELECT 16 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_QUARTER = 16,
WHEN (SEL.numPeriod=6) AND (SEL.type = 4) THEN (SELECT 32 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_HALFYEAR = 32,
WHEN (SEL.numPeriod=12) AND (SEL.type = 4) THEN (SELECT 64 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_YEAR = 64,
WHEN (SEL.type = 4) THEN (SELECT 16777216 FOR XML PATH ('selectiveRule'), TYPE)					--SELECTIVE_ADVANCED 16777216
						END)
						FROM archSelectiveCopy SEL WITH(NOLOCK)
						WHERE SEL.copyId= AGC.id
						FOR XML PATH ('selectiveCopyRules'),TYPE)
					FROM archGroupCopy AGC
						WHERE AGC.archGroupId = @storagePolicyId
							AND AGC.type <> 5
			FOR XML PATH('copy'), TYPE)
		RETURN @storagePolicyCopyXML
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetStoragePolicyCopyDetails]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetStoragePolicyCopyDetails' AND revision = '1.1.2.7')

  insert into GXDBVersions values(5, 'GetStoragePolicyCopyDetails',  '1.1.2.7', 'GetStoragePolicyCopyDetails', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
