

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSpaceSavingPct.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSpaceSavingPct'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSpaceSavingPct]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSpaceSavingPct]
  delete from GXDBVersions where name = 'GetSpaceSavingPct' and type = 5
END
GO

	CREATE FUNCTION GetSpaceSavingPct(@uncompSize BIGINT, @jobId INTEGER, @ccId INTEGER, @optype INTEGER, @status INTEGER)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sizeOnMedia BIGINT
		DECLARE @spaceSavingPct INTEGER
		SELECT @sizeOnMedia = SUM(ISNULL(S.sizeOnMedia, 0)) FROM JMJobDataStats S
				WHERE S.commcellId = @ccId AND S.jobId = @jobId AND S.AuxCopyJobId = 0

		IF @opType = 60 OR @status IN (2, 9, 4)-- 60->SNAPTOTAPE,2->failed,4->killed,9->Dropped
		BEGIN
			SET @spaceSavingPct = -1
			RETURN @spaceSavingPct * 100.0
		END
		IF @uncompSize > @sizeOnMedia
			SET @spaceSavingPct = ((@uncompSize - @sizeOnMedia)/(@uncompSize * 1.0)) * 100
		ELSE
			SET @spaceSavingPct = 0
		RETURN @spaceSavingPct * 100.0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSpaceSavingPct]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSpaceSavingPct' AND revision = '1.4.200.1')

  insert into GXDBVersions values(5, 'GetSpaceSavingPct',  '1.4.200.1', 'GetSpaceSavingPct', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
