

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSizeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSizeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSizeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSizeString]
  delete from GXDBVersions where name = 'GetSizeString' and type = 5
END
GO

	CREATE FUNCTION GetSizeString ( @size DECIMAL(38) )
	RETURNS VARCHAR(128)
	AS
	BEGIN
		DECLARE @sizefl		FLOAT
		DECLARE @sizeStr	VARCHAR(100)


		IF @size >= POWER(1024.0,7)
		    SET @sizefl = @size/POWER(1024.0,7)
		ELSE IF @size >= POWER(1024.0,6)
			SET  @sizefl = @size/POWER(1024.0,6)
		ELSE IF @size >= POWER(1024.0,5)
			SET  @sizefl = @size/POWER(1024.0,5)
		ELSE IF @size >= POWER(1024.0,4)
			SET  @sizefl = @size/POWER(1024.0,4)
		ELSE IF @size >= 1024 * 1024 * 1024
			SET  @sizefl = @size/POWER(1024.0,3)
        ELSE IF @size >= 1024 * 1024
            SET  @sizefl = @size/POWER(1024.0,2)
	    ELSE IF @size >= 1024
			SET @sizefl = convert(float, @size) / 1024
		ELSE
			SET @sizefl = convert(float, @size)


		SET @sizeStr = STR(@sizefl, 38, 2)

		IF @size >= POWER(1024.0,7)
			SET @sizeStr = @sizeStr + ' ZB'
		ELSE IF @size >= POWER(1024.0,6)
			SET @sizeStr = @sizeStr + ' EB'
		ELSE IF @size >= POWER(1024.0,5)
			SET @sizeStr = @sizeStr + ' PB'
		ELSE IF @size >= POWER(1024.0,4)
			SET @sizeStr = @sizeStr + ' TB'
		ELSE IF @size >= POWER(1024.0,3)
			SET @sizeStr = @sizeStr + ' GB'
		ELSE IF @size >= 1024 * 1024
			SET @sizeStr = @sizeStr + ' MB'
		ELSE IF @size >= 1024
			SET @sizeStr = @sizeStr + ' KB'
		ELSE
			SET @sizeStr = @sizeStr + ' Bytes'

		RETURN @sizeStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSizeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSizeString' AND revision = '1.2.198.1')

  insert into GXDBVersions values(5, 'GetSizeString',  '1.2.198.1', 'GetSizeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
