

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetServicePackSortRank.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetServicePackSortRank'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetServicePackSortRank]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetServicePackSortRank]
  delete from GXDBVersions where name = 'GetServicePackSortRank' and type = 5
END
GO

 CREATE FUNCTION GetServicePackSortRank ( @Version nvarchar(32) )
 RETURNS INT
 WITH ENCRYPTION
 AS
 BEGIN
	IF  ISNULL(@Version, '') = '' RETURN 0
	SET @Version = LTRIM(@Version)
	IF  ISNUMERIC(LEFT(@Version, 1)) = 0 RETURN 0
	SET @Version = RTRIM(@Version)
	IF  RIGHT(@Version, 1) IN ('-', '+') SET @Version = LEFT(@Version, LEN(@Version)-1)

	DECLARE @posSP  INT = CHARINDEX('SP',  @Version)
	DECLARE @posHPK INT = CHARINDEX('.', @Version)
	DECLARE @relNo  INT = 0
	DECLARE @spNo   INT = 0
	DECLARE @hpkNo  INT = 0

	SET @relNo = CAST(SUBSTRING(@Version, 0, CASE WHEN @posSP > 0 THEN @posSP ELSE LEN(@Version) END) AS FLOAT)

	IF  @posHPK > 0
		SET @hpkNo = CAST(SUBSTRING(@Version, @posHPK+1, LEN(@Version)) AS FLOAT)

	IF  @posSP > 0
	BEGIN
		SET @Version = SUBSTRING(@Version, @posSP+2, CASE WHEN @posHPK > 0 THEN @posHPK-@posSP-2 ELSE LEN(@Version) END)
		SET @Version = RTRIM(@Version)
		IF  RIGHT(@Version, 1) IN ('-', '+') SET @Version = LEFT(@Version, LEN(@Version)-1)
		IF  ASCII(RIGHT(@Version, 1)) >= 97
		BEGIN
			SET @hpkNo = ASCII(RIGHT(@Version, 1)) - 96
			SET @Version = LEFT(@Version, LEN(@Version)-1)
		END
		SET @spNo = CAST(@Version AS FLOAT)
	END

	RETURN (@relNo*1000 + @spNo*10 + @hpkNo)
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetServicePackSortRank]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetServicePackSortRank' AND revision = '1.5.44.3')

  insert into GXDBVersions values(5, 'GetServicePackSortRank',  '1.5.44.3', 'GetServicePackSortRank', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
