

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetServicePackNumbers.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetServicePackNumbers'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetServicePackNumbers]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetServicePackNumbers]
  delete from GXDBVersions where name = 'GetServicePackNumbers' and type = 5
END
GO

	CREATE FUNCTION GetServicePackNumbers(@spName varchar(8))
	RETURNS @servicePackNumbers table
	(
		major int,
		minor int
	)
	AS
	BEGIN
		DECLARE @spPrefixIndex int = 0
		DECLARE @majorIndex int = 0
		DECLARE @minorIndex int = 0
		DECLARE @majorVersion int = 0
		DECLARE @minorVersion int = 0
		DECLARE @minorVersionChar char
		DECLARE @spnameLen int
		SET @spnameLen = LEN(@spName)
		SET @spPrefixIndex = PATINDEX('%SP%', @spName)
		SET @majorIndex = PATINDEX('%[0-9]%', @spName)

		IF @spPrefixIndex > 0
			BEGIN
				SET @minorIndex = PATINDEX('%[a-z,A-Z]%', SUBSTRING(@spName, @spPrefixIndex + 2, (@spnameLen - (@spPrefixIndex - 1) + 2)))
				IF @minorIndex > 0
					SET @minorIndex = @minorIndex + @spPrefixIndex + 1
			END
		ELSE
			SET @minorIndex = PATINDEX('%[a-z,A-Z]%',@spName)

		IF @minorIndex > 0
		BEGIN
			SELECT @majorVersion = CONVERT(integer, SUBSTRING(@spName, @majorIndex, @minorIndex - @majorIndex))
			SELECT @minorVersionChar = CONVERT(char, UPPER(SUBSTRING(@spName, @minorIndex, 1)))
			SET @minorVersion = CASE WHEN ASCII(@minorVersionChar) BETWEEN 65 AND 90 THEN ASCII(@minorVersionChar) - 64 END
		END
		ELSE IF @majorIndex > 0
			SELECT @majorVersion = CONVERT(integer, SUBSTRING(@spName, @majorIndex, (@spnameLen - @majorIndex) + 1))

		INSERT INTO @servicePackNumbers
		SELECT @majorVersion, @minorVersion

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetServicePackNumbers]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetServicePackNumbers' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'GetServicePackNumbers',  '1.1.2.2', 'GetServicePackNumbers', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
