

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSelectedSubClients.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: GetSelectedSubClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSelectedSubClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSelectedSubClients]
  delete from GXDBVersions where name = 'GetSelectedSubClients' and type = 5
END
GO

	CREATE FUNCTION GetSelectedSubClients( @treeSelection XML)
		RETURNS @selectedIdsTbl TABLE(
				subClientId INT
		)
		AS
		BEGIN

			DECLARE @handle INT;
			DECLARE @tblSubclientSelection TABLE (clientId INT, appType INT, instance INT, backupSet INT, subclient INT)

			INSERT INTO @tblSubclientSelection
			SELECT	ISNULL(item.c.value('./@clientId', 'INT'), 0), ISNULL(item.c.value('./@applicationId', 'INT'), 0), ISNULL(item.c.value('./@instanceId', 'INT'), 0),
					ISNULL(item.c.value('./@backupsetId', 'INT'), 0), ISNULL(item.c.value('./@subclientId', 'INT'), 0)
			FROM	@treeSelection.nodes('/TreeSelections/subclientFilterList') item(c)

			INSERT INTO @selectedIdsTbl
			SELECT	id FROM APP_Application A, @tblSubClientSelection S
			WHERE	(A.clientId = S.clientId OR S.clientId = 0)
				AND	(A.appTypeId = S.appType OR S.appType = 0)
				AND (A.instance = S.instance OR S.instance = 0)
				AND (A.backupSet = S.backupSet OR S.backupSet = 0)
				AND (A.id = S.subclient OR S.subclient = 0)

		RETURN
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSelectedSubClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSelectedSubClients' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetSelectedSubClients',  '1.1', 'GetSelectedSubClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
