

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSPBkpInfoForMMSummPage.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: GetSPBkpInfoForMMSummPage'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSPBkpInfoForMMSummPage]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSPBkpInfoForMMSummPage]
  delete from GXDBVersions where name = 'GetSPBkpInfoForMMSummPage' and type = 5
END
GO

CREATE FUNCTION GetSPBkpInfoForMMSummPage (@spId integer)
RETURNS @BkpInfo table (jobCount int, sizeOnMedia bigint)
AS
BEGIN
DECLARE @l_defaultCopy	INT
DECLARE @l_spFlags INT
DECLARE @l_policyType INT
SELECT	@l_defaultCopy = defaultCopy, @l_spFlags = flags, @l_policyType = type
FROM	archGroup WITH (NOLOCK)
WHERE	id = @spId
IF @l_spFlags & ( 256 | 8388608 | 16384 ) = 0
BEGIN
	DECLARE @tempJobStats table
	(
		jobId int,
		commcellId int,
		sizeOnMedia bigint,
		primary key(jobId, commcellId)
	)
	DECLARE @tempValidAppIds table
	(
		appId int
	)
	INSERT @tempValidAppIds
	SELECT distinct appid FROM archFile WITH (NOLOCK) WHERE archGroupid = @spId and isValid > 0
	INSERT @tempJobStats
	SELECT distinct jbkp.jobId, jbkp.commCellId, 0 FROM JMBkpStats jbkp
	INNER JOIN @tempValidAppIds App ON jbkp.appid = App.appId
INNER JOIN App_Commcell C ON jbkp.commcellId = C.id AND (C.type = 1 OR @l_policyType = 5)
	INNER JOIN JmJobDataStats jds ON jbkp.jobid = jds.jobid AND jbkp.commCellid = jds.commCellId
	WHERE jbkp.status IN (1, 3, 14, 16)
		AND jds.status IN (2, 100)
		AND (jbkp.dataArchGrpId = @spId OR jbkp.logArchGrpId = @spId OR jbkp.diffArchGrpId = @spId)
	OPTION(RECOMPILE)
	INSERT @tempJobStats
	SELECT distinct jbkp.jobId, jbkp.commCellId, 0 FROM JMAdminJobStatsTable jbkp
	INNER JOIN @tempValidAppIds App ON jbkp.appid = App.appId
	INNER JOIN JmJobDataStats jds ON jbkp.jobid = jds.jobid AND jbkp.commCellid = jds.commCellId
	WHERE jds.status IN (2, 100)
		AND jbkp.archGrpID = @spId
	OPTION(RECOMPILE)
	DELETE  @tempJobStats
    FROM    @tempJobStats A, JMPreparedJob B
    WHERE   A.jobId = B.jobId AND A.commCellId = B.commCellId
    AND B.status = 3
	DELETE @tempJobStats
	FROM @tempJobStats A left outer join
	(SELECT	distinct B.jobId, B.commCellId
	FROM	JMJobDataStats B WITH (NOLOCK), @tempJobStats J
	WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
	GROUP BY B.jobId, B.commCellId, B.archGrpCopyId
	HAVING
	(MAX(CASE WHEN ((B.status IN (101, 102, 103, 1000)) OR (B.disabled&256=256)) THEN 1 ELSE 0 END))  = 0) T
	 ON A.jobId = T.jobId AND A.commcellId = T.commcellId
	 WHERE T.jobId is null
	UPDATE	@tempJobStats
	SET		sizeOnMedia = S.sizeOnMedia
	FROM	(SELECT	J.jobId, J.commCellId, SUM(J.sizeOnMedia) AS sizeOnMedia
			FROM	@tempJobStats T, JMJobDataStats J WITH (NOLOCK)
			WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = @l_defaultCopy
			GROUP BY J.jobId, J.commCellId
			HAVING  SUM(J.sizeOnMedia) > 0) S, @tempJobStats jobs
	WHERE	jobs.jobId = S.jobId AND jobs.commCellId = S.commCellId
	IF EXISTS (SELECT 1 FROM @tempJobStats WHERE sizeOnMedia = 0)
	BEGIN
		UPDATE jobs
		SET sizeOnMedia = J.totalBackupSize
		FROM @tempJobStats jobs
		JOIN JMBkpStats J ON jobs.jobId = J.jobId AND J.commCellId = jobs.commCellId
		WHERE jobs.sizeOnMedia = 0
	END
	INSERT INTO @BkpInfo
	SELECT COUNT(jobId), SUM(sizeOnMedia) from @tempJobStats
END
ELSE IF (@l_spFlags & 16384) = 0
BEGIN
	DECLARE @tempJobStatsGDSP table
	(
		jobId int,
		commcellId int,
		agedFlag int,
		sizeOnMedia bigint,
		copyId int,
		dataStatus int,
		primary key(jobId, commcellId, copyId)
	)
	DECLARE @l_copyId int = 0
	DECLARE CopyIdListCursor CURSOR FOR
	SELECT copyId from archCopyToGlobalPolicy G WHERE G.globalPolicyId = @spId
	OPEN CopyIdListCursor
	FETCH NEXT FROM CopyIdListCursor INTO @l_copyId
	WHILE(@@FETCH_STATUS = 0)
	BEGIN
		DECLARE @policyId int
		SET @policyId = 0
		SELECT @policyId = archGroupId FROM archGroupCopy WHERE id = @l_copyId
		INSERT INTO @tempJobStatsGDSP
		SELECT jds.jobId, jds.commCellId, MAX(jds.disabled & 256), SUM(jds.sizeOnMedia), @l_copyId, CASE WHEN MIN(jds.status) = 100 AND MAX(jds.status) = 101 THEN 103 ELSE MAX(jds.status) END
		FROM JMBkpStats jbkp INNER JOIN JMJobDataStats jds ON jbkp.jobId = jds.jobId AND jbkp.commCellId = jds.commCellId
		left outer join @tempJobStatsGDSP jobs ON jds.jobId = jobs.jobId AND jds.commCellId = jobs.commcellId AND jds.archGrpCopyId = jobs.copyId
		WHERE jbkp.status IN (1, 3, 14, 16) AND (jbkp.dataArchGrpId = @policyId OR jbkp.logArchGrpId = @policyId OR jbkp.diffArchGrpId = @policyId)
		AND jds.archGrpCopyId = @l_copyId AND jobs.jobId is null
		GROUP BY jds.jobId, jds.commCellId
		FETCH NEXT FROM CopyIdListCursor INTO @l_copyId
	END
	CLOSE CopyIdListCursor
	DEALLOCATE CopyIdListCursor
	DELETE @tempJobStatsGDSP WHERE agedFlag = 256
	DELETE @tempJobStatsGDSP WHERE dataStatus not in (100, 103)
	INSERT INTO @BkpInfo
	SELECT COUNT(jobId), SUM(sizeOnMedia) from @tempJobStatsGDSP
END
RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSPBkpInfoForMMSummPage]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSPBkpInfoForMMSummPage' AND revision = '1.3.34.5')

  insert into GXDBVersions values(5, 'GetSPBkpInfoForMMSummPage',  '1.3.34.5', 'GetSPBkpInfoForMMSummPage', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
