

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSLADays.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSLADays'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSLADays]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSLADays]
  delete from GXDBVersions where name = 'GetSLADays' and type = 5
END
GO

 CREATE FUNCTION GetSLADays (@i_clientId INT, @i_appType INT, @i_appId INT)
 RETURNS @Results TABLE (slaDays INT, slaDaysLevel VARCHAR(32), entityId INT)
 AS
 BEGIN

 DECLARE @slaDays		INT
 DECLARE @slaDaysLevel	VARCHAR(32)
 DECLARE @entityId		INT

 IF @i_appType <> 106 AND @i_appId > 0
 BEGIN
 	SELECT	@slaDays = CAST(P.attrVal AS INT), @slaDaysLevel = 'Subclient Plan', @entityId = P.componentNameId
 	FROM	APP_PlanProp P WITH (NOLOCK)
 			INNER JOIN APP_SubClientProp S WITH (NOLOCK) ON P.componentNameId = CAST(S.attrVal AS INT)
 	WHERE	P.attrName = 'SLA option in days' AND P.attrVal <> '0' AND P.modified = 0
 		AND S.componentNameId = @i_appId
 		AND S.cs_attrName = CHECKSUM(N'Associated Plan') AND S.attrName LIKE 'Associated Plan' AND S.modified = 0
		AND EXISTS (SELECT 1 FROM APP_PlanProp WITH (NOLOCK) WHERE componentNameId = P.componentNameId AND attrName = 'SLA option' AND attrVal = '2' AND modified = 0)

 	IF @slaDays IS NULL
 	SELECT	@slaDays = CAST(P.attrVal AS INT), @slaDaysLevel = 'Backupset Plan', @entityId = P.componentNameId
 	FROM	APP_PlanProp P WITH (NOLOCK)
 			INNER JOIN APP_BackupsetProp S WITH (NOLOCK) ON P.componentNameId = CAST(S.attrVal AS INT)
 			INNER JOIN APP_Application A WITH (NOLOCK) ON S.componentNameId = A.backupset
 	WHERE	P.attrName = 'SLA option in days' AND P.attrVal <> '0' AND P.modified = 0
 		AND S.attrName LIKE 'Associated Plan' AND S.modified = 0
 		AND A.id = @i_appId AND A.backupset > 1
		AND EXISTS (SELECT 1 FROM APP_PlanProp WITH (NOLOCK) WHERE componentNameId = P.componentNameId AND attrName = 'SLA option' AND attrVal = '2' AND modified = 0)

 	IF @slaDays IS NULL
 	SELECT	@slaDays = CAST(P.attrVal AS INT), @slaDaysLevel = 'Client Plan', @entityId = P.componentNameId
 	FROM	APP_PlanProp P WITH (NOLOCK)
 			INNER JOIN APP_ClientProp C WITH (NOLOCK) ON P.componentNameId = CAST(C.attrVal AS INT)
 	WHERE	P.attrName = 'SLA option in days' AND P.attrVal <> '0' AND P.modified = 0
 		AND C.componentNameId = @i_clientId
 		AND C.attrName LIKE 'Associated Plan' AND C.modified = 0
		AND EXISTS (SELECT 1 FROM APP_PlanProp WITH (NOLOCK) WHERE componentNameId = P.componentNameId AND attrName = 'SLA option' AND attrVal = '2' AND modified = 0)
 END

 IF @slaDays IS NULL
 	SELECT	@slaDays = T.slaDays, @slaDaysLevel = 'Client Group', @entityId = T.componentId
	FROM	(
			SELECT	componentId, longVal AS slaDays, ROW_NUMBER() OVER (ORDER BY longVal) AS rowId
			FROM	APP_ComponentProp WITH (NOLOCK)
			WHERE	componentId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientId = @i_clientId)
				AND componentId NOT IN (
					SELECT componentId FROM APP_ComponentProp CP WITH (NOLOCK)
					WHERE componentType = 8 AND propertyTypeId = 3327 AND longVal = 1 AND modified = 0)
				AND componentType = 8 AND propertyTypeId = 3300 AND modified = 0) T
	WHERE	T.rowId = 1

 IF @slaDays IS NULL
 	SELECT	@slaDays = longVal, @slaDaysLevel = 'CommCell', @entityId = 2
 	FROM	APP_ComponentProp WITH (NOLOCK)
 	WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3300 AND modified = 0

 IF @slaDays IS NULL
 	SELECT	@slaDays = 30, @slaDaysLevel = 'CommCell', @entityId = 2

 INSERT INTO @Results
 SELECT @slaDays, @slaDaysLevel, @entityId

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSLADays]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSLADays' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'GetSLADays',  '1.1.2.2', 'GetSLADays', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
