

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetQRDestination.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetQRDestination'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetQRDestination]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetQRDestination]
  delete from GXDBVersions where name = 'GetQRDestination' and type = 5
END
GO

	CREATE FUNCTION GetQRDestination(@jobId INTEGER, @ccId INTEGER)
	RETURNS NVARCHAR(MAX)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @QrDest NVARCHAR(MAX)
		SET @QrDest = N''
		DECLARE @clName VARCHAR(510)
		DECLARE @devName VARCHAR(510)
		DECLARE qrCur CURSOR FOR
			SELECT DstClientName, DstDevName FROM QRJobVolumeHistory
			WHERE jobId = @jobId AND commcellId = @ccId
		OPEN qrCur
		FETCH NEXT FROM qrCur INTO @clName, @devName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @QrDest = @QrDest + @clName
			SET @QrDest = @QrDest + ':'
			SET @QrDest = @QrDest + @devName
			FETCH NEXT FROM qrCur INTO @clName, @devName
			IF @@FETCH_STATUS = 0
				SET @QrDest = @QrDest + ', '
		END
		CLOSE qrCur
		DEALLOCATE qrCur
		RETURN @QrDest
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetQRDestination]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetQRDestination' AND revision = '1.2.208.1')

  insert into GXDBVersions values(5, 'GetQRDestination',  '1.2.208.1', 'GetQRDestination', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
