

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetQNetPruneTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetQNetPruneTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetQNetPruneTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetQNetPruneTime]
  delete from GXDBVersions where name = 'GetQNetPruneTime' and type = 5
END
GO

	CREATE FUNCTION GetQNetPruneTime ()
	RETURNS int
	-- WITH ENCRYPTION
	BEGIN
		DECLARE @IsQNetInstalled	int
		DECLARE	@QNetPruneTime		DATETIME
		DECLARE	@QNetJobPruneTime	DATETIME
		DECLARE	@QNetMMPruneTime	DATETIME
		DECLARE	@CurrentUTCTime		DATETIME
		DECLARE @DayHistoryPeriod	int
		DECLARE	@QNetAuxJobPruneTime	DATETIME
		DECLARE	@QNetMMStatPruneTime	DATETIME
		DECLARE	@QNetMMDrvPruneTime		DATETIME
		SET	@CurrentUTCTime = GETUTCDATE()
        DECLARE @oneYear			DATETIME = dateadd(day, -365, @CurrentUTCTime)
		SELECT	TOP 1 @DayHistoryPeriod = CONVERT(int, CONVERT(varchar(5), Value))
		FROM	GXGlobalParam
		WHERE	name = 'DailyHistoryForQNetRetentionPeriod'
		IF (@DayHistoryPeriod IS NULL)
			SET	@DayHistoryPeriod = 7
		IF (@QNetJobPruneTime IS NULL)
			SET	@QNetJobPruneTime = dateadd(day, - @DayHistoryPeriod, @CurrentUTCTime)
		ELSE
			IF ( (@QNetAuxJobPruneTime >= @oneYear  )
 				AND (@QNetAuxJobPruneTime IS NOT NULL )
				AND (@QNetAuxJobPruneTime < @QNetJobPruneTime) )
				SET @QNetJobPruneTime = @QNetAuxJobPruneTime
			IF ( (@QNetMMStatPruneTime >= @oneYear  )
 				AND (@QNetMMStatPruneTime IS NOT NULL )
				AND (@QNetMMStatPruneTime < @QNetMMPruneTime) )
				SET @QNetMMPruneTime = @QNetMMStatPruneTime
			IF ( (@QNetMMDrvPruneTime >= @oneYear  )
 				AND (@QNetMMDrvPruneTime IS NOT NULL )
				AND (@QNetMMDrvPruneTime < @QNetMMPruneTime))
				SET @QNetMMPruneTime = @QNetMMDrvPruneTime
		IF (@QNetMMPruneTime IS NULL)
			SET	@QNetMMPruneTime = dateadd(day, - @DayHistoryPeriod, @CurrentUTCTime)
		RETURN (CASE WHEN (@QNetJobPruneTime < @oneYear) OR (@QNetMMPruneTime < @oneYear)
				THEN dbo.GetUnixTime(@oneYear)
				WHEN (@QNetJobPruneTime < @QNetMMPruneTime)
				THEN dbo.GetUnixTime(@QNetJobPruneTime)
				ELSE dbo.GetUnixTime(@QNetMMPruneTime)
			END)
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetQNetPruneTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetQNetPruneTime' AND revision = '1.7.180.2')

  insert into GXDBVersions values(5, 'GetQNetPruneTime',  '1.7.180.2', 'GetQNetPruneTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
