

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetPackageID.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetPackageID'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetPackageID]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetPackageID]
  delete from GXDBVersions where name = 'GetPackageID' and type = 5
END
GO

	CREATE FUNCTION GetPackageID (@i_appType INTEGER, @i_SimOSID INTEGER)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE	@packageID	INT
	 	DECLARE	@osType		VARCHAR(256)
	 	DECLARE	@osSubType	VARCHAR(256)
	 	DECLARE @pkgStartID	INT
	 	DECLARE @pkgEndID	INT
	 	SELECT @osType = type, @osSubType = subType FROM SimOperatingSystem WHERE id = @i_SimOSID
	 	SET @pkgStartID = (CASE @osType	WHEN 'Unix' THEN 1000
	 					WHEN 'Netware' THEN 2000
	 					ELSE 0 END)
	 	SET @pkgEndID	= (CASE @osType	WHEN 'Unix' THEN 2000
	 					WHEN 'Netware' THEN 3000
	 					ELSE 1000 END)
		IF @i_appType = 1001 AND @osType = 'Unix'				-- UNIX Base client
			SET @packageID = 1002
		ELSE IF @i_appType IN (17,19,21,29,36,63,74)			-- UNIX FileSystem
			SET @packageID = 1002
		ELSE IF @i_appType = 64 AND @i_SimOSID = 42				-- IRIX FileSystem
			SET @packageID = 1002
		ELSE IF @i_appType IN (select type from APP_iDAType (NOLOCK) where name like 'Windows%File System')	-- WIN FileSystem
			SET @packageID = 1
		ELSE IF (@i_appType = 1002)	AND (@osType = 'Windows')	-- WIN Media Agent
			SET @packageID = 51
	 	ELSE IF @i_appType = 1002 AND @osType = 'Unix'			-- UNIX Media Agent
	 		SET @packageID = 1301
	 	ELSE IF @i_appType = 44
	 		SET @packageID = 154
	 	ELSE IF @i_appType = 14
	 		SET @packageID = 152
	 	ELSE IF @i_appType = 15
	 		SET @packageID = 151
	 	ELSE
			SET @packageID = ISNULL((SELECT distinct simPackageId FROM simPackageMap WHERE appType = @i_appType AND simOSId IN (0, @i_SimOSID) AND simPackageId > @pkgStartID AND simPackageId < @pkgEndID), 0)
		IF @packageID = 0
			SET @packageID = ISNULL((SELECT distinct simPackageId FROM simPackageMap
						 WHERE appType = @i_appType AND simOSId IN
								(	select id from simOperatingSystem
									where type = @osType AND subType = @osSubType AND Version in ('new', 'any') AND PlatformType = 'Any')), 0)
		IF @packageID = 0
			SET @packageID = ISNULL((SELECT distinct simPackageId FROM simPackageMap WHERE appType = @i_appType AND simOSId = 0), 0)
		RETURN @packageID
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetPackageID]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetPackageID' AND revision = '1.9.192.6')

  insert into GXDBVersions values(5, 'GetPackageID',  '1.9.192.6', 'GetPackageID', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
