

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetOperationWindowDetails.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetOperationWindowDetails'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetOperationWindowDetails]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetOperationWindowDetails]
  delete from GXDBVersions where name = 'GetOperationWindowDetails' and type = 5
END
GO

 SET ANSI_NULLS ON
 GO
 SET QUOTED_IDENTIFIER ON
 GO
 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 GO
	CREATE FUNCTION GetOperationWindowDetails(@ruleId INT, @level INT)
	RETURNS XML
		AS
		BEGIN
	DECLARE @OperationWindowDetailXML XML
	IF @level = 0
		RETURN (SELECT [ruleId] = @ruleId FOR XML PATH (''), TYPE)
	;WITH NUM_GEN (n) AS
     (
            SELECT 0
            UNION ALL
			SELECT n + 1
            FROM  NUM_GEN
            WHERE n + 1 <= 20
     )
	 SELECT @OperationWindowDetailXML = (SELECT
				TOP 1
				[ruleId] = Rules.id,
				[ruleEnabled] = Rules.enable,
				[startDate] = Rules.startDate,
				[endDate] = Rules.endDate,
				[name] = Rules.description,
				[level] = 7,
				(SELECT [operations/@val] = IIF((Rules.opType & (POWER(2,n))) <> 0, POWER(2,n), NULL) FROM NUM_GEN WHERE n < 20 FOR XML PATH (''), TYPE),
					(SELECT
					[@startTime] = dayTime.startTime,
					[@endTime] = dayTime.endTime,
					(SELECT [dayOfWeek/@val] = IIF((dayTime.daysOfWeek & (POWER(2,n))) <> 0, n, NULL) FROM NUM_GEN WHERE n < 7 FOR XML PATH (''), TYPE)
					FROM APP_OpWindowRule (NOLOCK) dayTime
					WHERE dayTime.id = Rules.id
					FOR XML PATH ('dayTime'), TYPE)
				FROM APP_OpWindowRule (NOLOCK) Rules
					WHERE Rules.id = @ruleId
				FOR XML PATH (''), TYPE)
			RETURN @OperationWindowDetailXML
		END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetOperationWindowDetails]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetOperationWindowDetails' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'GetOperationWindowDetails',  '1.1.2.2', 'GetOperationWindowDetails', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
