

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetOpWindowLevelIfMatched.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetOpWindowLevelIfMatched'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetOpWindowLevelIfMatched]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetOpWindowLevelIfMatched]
  delete from GXDBVersions where name = 'GetOpWindowLevelIfMatched' and type = 5
END
GO

    SET QUOTED_IDENTIFIER ON
    GO

		--Funtion Return values:
		--		OPERATION_ALLOWED = -1	Operation is allowed
		--		OPRULE_CS = 0			Operation Not allowed at CS level
		--		OPRULE_CLIENTGROUP = 1	Operation Not allowed at CG level
		--		OPRULE_CLIENT = 2		Operation Not allowed at Client
		--		OPRULE_IDA = 3			Operation Not allowed at iDA
		--		OPRULE_INSTANCE = 4		Operation Not allowed at instance
		--		OPRULE_BACKUPSET = 5	Operation Not allowed at Backup set
		--		OPRULE_SUBCLIENT = 6	Operation Not allowed at Subclient

	CREATE FUNCTION GetOpWindowLevelIfMatched
	(
	 @operationType	INTEGER, --Required
	 @commCellID	INTEGER, --Required
	 @clientID		INTEGER, --Required
	 @appType		INTEGER, --Required to do CS level alone (apptype= 1000)
	 @instacenId	INTEGER, --Optional
	 @backupsetID	INTEGER, --Optional
	 @subClientID	INTEGER  --Optional
	)
	RETURNS INTEGER
	AS
	BEGIN

	DECLARE @isOperationAllowed INTEGER
	DECLARE @OperationmatchLevel INTEGER

	SELECT @isOperationAllowed = isOperationAllowed, @OperationmatchLevel = MatchLevel
		FROM dbo.IsOperationAllowedAndMatchedLevel(@operationType,@commCellID,@clientID,@appType,@instacenId,@backupsetID,@subClientID,0, 0)

	RETURN @OperationmatchLevel;
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetOpWindowLevelIfMatched]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetOpWindowLevelIfMatched' AND revision = '')

  insert into GXDBVersions values(5, 'GetOpWindowLevelIfMatched',  '', 'GetOpWindowLevelIfMatched', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
