

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetNumberOfStreamsSupported.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: GetNumberOfStreamsSupported'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetNumberOfStreamsSupported]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetNumberOfStreamsSupported]
  delete from GXDBVersions where name = 'GetNumberOfStreamsSupported' and type = 5
END
GO

 SET ANSI_NULLS ON
 GO
 SET QUOTED_IDENTIFIER ON
 GO
	CREATE FUNCTION [dbo].[GetNumberOfStreamsSupported](@subclientId INT)
	RETURNS INT
		AS
		BEGIN
			DECLARE @clientId INT = 0
			DECLARE @appTypeId INT = 0
			DECLARE @instanceId INT = 0
			DECLARE @versionFormat NVARCHAR(MAX) = NULL
			SELECT @clientId = clientId, @appTypeId = appTypeId, @instanceId = instance  FROM APP_Application WITH (NOLOCK)
			WHERE id = @subclientId
			IF @appTypeId IN (1, 11,
										33, 34,
										42, 43) -- WINDOWS FS
							OR @appTypeId IN (17, 18,
										17, 19,
										20,19, 21,
										29, 36, 63,
										74, 38) -- UNIX FS
			BEGIN
				SELECT @versionFormat = attrVal FROM APP_ClientProp WITH (NOLOCK)
				WHERE componentNameId = @clientId AND attrName = N'SP Version Info' AND modified = 0
				IF @versionFormat IS NOT NULL AND @appTypeId <> 38
				BEGIN
					DECLARE @formattedVersion NVARCHAR(20) = NULL
					SELECT @formattedVersion = dbo.ConvertSPFormat(@versionFormat)
					DECLARE @index INT  = CHARINDEX('.', @formattedVersion)
					DECLARE @release INT = SUBSTRING(@formattedVersion,1, @index-1)
					DECLARE @majorSP INT = REPLACE(SUBSTRING(@formattedVersion,@index+1, 2), '.', '')
					IF (@release >= 11)
					BEGIN
						IF (@majorSP >= 22 AND @release = 11)
							RETURN 0 -- NAS clients won't have majorSP, hence this condition won't be hit
						ELSE
						BEGIN
							-- 11.0 clients with major SP < 22 or 12.0 clients fall here
							DECLARE @clientStatus INT = NULL
							SELECT @clientStatus = status FROM APP_Client WITH (NOLOCK)
							WHERE id = @clientId
							IF @clientStatus & 0x0080 = 0x0080
							BEGIN
								RETURN 0
							END
							ELSE
							BEGIN
								IF (@clientStatus & 0x8000000 = 0x8000000) OR @release >= 12
									RETURN 0 -- Non NDMP client and other clients
							END
						END
					END
				END
				RETURN 4
			END
			ELSE IF (@appTypeId = 64)
			BEGIN
				DECLARE @clusterType INT = 0
				SELECT @clusterType = ISNULL(CAST(attrval as INT), 0) FROM APP_Application app WITH (NOLOCK)
					INNER JOIN APP_InstanceProp AIP WITH (NOLOCK) ON
							app.instance = AIP.componentNameId AND
							app.appTypeId = 64 AND
							AIP.attrname = 'Distributed Cluster Type' AND
							app.id = @subclientId AND
							AIP.modified = 0
				IF @clusterType <> 1 AND @clusterType <> 15 -- 1 - DistributedClusterType_GREENPLUM, 15 - INDEXSERVER
				-- Other than GreenPlum and index server, all distributed IDA clients support automatic streams
						RETURN 0
				RETURN 4
			END
			ELSE IF (@appTypeId = 134)
			BEGIN
				DECLARE @instanceType INT = 0
				SELECT @instanceType = ISNULL(CAST(attrval as INT), 0) FROM APP_Application app WITH (NOLOCK)
					INNER JOIN APP_InstanceProp AIP WITH (NOLOCK) ON
							app.instance = AIP.componentNameId AND
							app.appTypeId = 134 AND
							AIP.attrname = 'Cloud Apps Instance Type' AND
							app.id = @subclientId AND
							AIP.modified = 0
				IF @instanceType = 33 OR @instanceType = 34 -- 33 - CloudAppsInstanceType_GIT_HUB, --34 - CloudAppsInstanceType_AZURE_DEVOPS. For Github and Azure_devOps app, return 0 by default
					RETURN 0
			END
			ELSE IF (@appTypeId = 106)
				RETURN 5
			ELSE IF (@appTypeId = 12)
				RETURN 2
			-- Default value to match CV_APPLICATION_DEFAULT_N_STREAMS
			RETURN 1
		END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetNumberOfStreamsSupported]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetNumberOfStreamsSupported' AND revision = '')

  insert into GXDBVersions values(5, 'GetNumberOfStreamsSupported',  '', 'GetNumberOfStreamsSupported', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
