

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetNASProxyVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetNASProxyVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetNASProxyVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetNASProxyVersion]
  delete from GXDBVersions where name = 'GetNASProxyVersion' and type = 5
END
GO

 	CREATE FUNCTION GetNASProxyVersion(@subclientId INTEGER, @jobType integer=0)
 	RETURNS INT
 	-- WITH ENCRYPTION
 	AS
 	BEGIN
 	DECLARE @releaseId INTEGER=0
 	DECLARE @inClientId INTEGER = NULL
 	DECLARE @inAppType INTEGER = NULL
 	DECLARE @proxyClientId INTEGER = 0
	DECLARE @onepass INTEGER = 0

	SELECT TOP 1  @inClientId = [clientId],
 			 @inAppType = [appTypeid]
				FROM APP_Application App WITH (NOLOCK)
				INNER JOIN APP_CLIENT C WITH (NOLOCK)
				ON App.id = @subclientId AND
 				C.id = App.clientId AND
 				(C.Status & 0x0080) = 0x0080

	IF ( @inClientId IS NULL)
 	BEGIN
 		RETURN @releaseId
 	END

 	-- NAS ONE PASS
 	SELECT TOP 1 @onepass = 1
 			FROM	App_subclientProp WITH (NOLOCK)
 			WHERE	componentnameId = @subclientId
 			AND attrName = N'Is Turbo Subclient' and modified = 0 and attrVal = '1'

 	IF @jobType = 1 AND @onepass = 0 --- SNAP TO TAPE
 	BEGIN
 		-- find the nas proxy clientId defined on subclient property
 		SET @proxyClientId = ISNULL((SELECT CONVERT(INT, attrVal)
 			FROM	App_subclientProp WITH (NOLOCK)
 			WHERE	componentnameId = @subclientId
 			AND attrName = N'Snap to tape : proxy to use' and modified = 0),0)
 	END

 	IF @proxyClientId = 0 AND @onepass = 0 -- SNAP AND ONE PASS ARE MUTUALLY EXCLUSIVE
 	BEGIN
 		-- find the nas proxy clientId defined on subclient property
 		SET @proxyClientId = ISNULL((SELECT CONVERT(INT, attrVal)
 			FROM	App_subclientProp WITH (NOLOCK)
 			WHERE	componentnameId = @subclientId
 			AND attrName = N'Snap copy : proxy to use' and modified = 0),0)
 	END

 	IF @proxyClientId = 0
 	BEGIN
 		-- find the nas proxy clientId defined on subclient property
 		SET @proxyClientId = ISNULL((SELECT CONVERT(INT, attrVal)
 			FROM	App_subclientProp WITH (NOLOCK)
 			WHERE	componentnameId = @subclientId
 			AND attrName = N'Turbo NAS Proxy Client' and modified = 0),0)
 	END

 	IF @proxyClientId = 0
 	BEGIN
 		SET @proxyClientId = ISNULL((SELECT CONVERT(INT, attrVal)
 		FROM	App_IdaProp WITH (NOLOCK)
 		WHERE	componentnameId = (SELECT id FROM App_IdaName WHERE clientId = @inclientId and appTypeId =  @inAppType)
 		AND attrName = N'FPOLICY PRIMARY CLIENT' and modified = 0),0)
 	END

 	SET @releaseId = (SELECT releaseId FROM App_client where id = @proxyClientId)
 	RETURN @releaseId

 	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetNASProxyVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetNASProxyVersion' AND revision = '')

  insert into GXDBVersions values(5, 'GetNASProxyVersion',  '', 'GetNASProxyVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
