

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMultinodeFederatedDataSourceId.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMultinodeFederatedDataSourceId'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMultinodeFederatedDataSourceId]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMultinodeFederatedDataSourceId]
  delete from GXDBVersions where name = 'GetMultinodeFederatedDataSourceId' and type = 5
END
GO

	CREATE FUNCTION GetMultinodeFederatedDataSourceId (@i_CloudId int = 0, @i_SourceType char(64) = NULL, @i_SubSourceType char(64) = NULL, @i_DatasourceId int = 0)
	RETURNS INT
	-- WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @multinodeDSId INT
	DECLARE @multinodeDSIdPropertyGuid NVARCHAR(36) = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC'
	DECLARE @multinodeDsTypeGuid NVARCHAR(36) = '04854E90-76E5-47D2-8C7F-28026DAABCC6'
	DECLARE @sourceTypePropertyGuid NVARCHAR(36) = '617BB3EF-65A9-49C1-BC60-8F3820149236'
	DECLARE @subSourceTypePropertyGuid NVARCHAR(36) = 'F3C96257-7468-41CD-B40D-CF6D0D945DD3'
	IF(@i_DatasourceId > 0)
	BEGIN
		SELECT @multinodeDSId = (SELECT CAST(SEDP.PropertyValue AS INT) FROM SEDataSourceProperty AS SEDP WITH(NOLOCK)
			INNER JOIN SEProperty AS SEP WITH(NOLOCK) ON SEDP.PropertyId = SEP.PropertyId
			WHERE SEP.PropertyGuid = @multinodeDSIdPropertyGuid AND SEDP.DataSourceId = @i_DatasourceId)
	END
	ELSE
	BEGIN
		DECLARE @multinodeDSTypeId INT = (SELECT TypeId FROM SEDataSourceType WITH(NOLOCK) WHERE TypeGuid = @multinodeDsTypeGuid)
		SELECT @multinodeDSId = (SELECT DS.DataSourceId FROM SEDataSource AS DS WITH (NOLOCK)
			INNER JOIN SEDataSourceProperty AS PROP WITH (NOLOCK) ON DS.DataSourceId = PROP.DataSourceId
			INNER JOIN SEProperty AS SE WITH (NOLOCK) ON SE.PropertyId = PROP.PropertyId
 			INNER JOIN SECollectionInfo AS SC WITH (NOLOCK) ON DS.CoreId = SC.CoreId WHERE ((SE.PropertyGuid = @sourceTypePropertyGuid AND PROP.PropertyValue = @i_SourceType) AND DS.DataSourceType = @multinodeDSTypeId AND SC.CloudID = @i_CloudId)
			INTERSECT
			SELECT DS.DataSourceId FROM SEDataSource AS DS WITH (NOLOCK)
			INNER JOIN SEDataSourceProperty AS PROP WITH (NOLOCK) ON DS.DataSourceId = PROP.DataSourceId
			INNER JOIN SEProperty AS SE WITH (NOLOCK) ON SE.PropertyId = PROP.PropertyId
			INNER JOIN SECollectionInfo AS SC WITH (NOLOCK) ON DS.CoreId = SC.CoreId WHERE ((SE.PropertyGuid = @subSourceTypePropertyGuid AND PROP.PropertyValue = @i_SubSourceType) AND DS.DataSourceType = @multinodeDSTypeId AND SC.CloudID = @i_CloudId))
	END
	RETURN ISNULL(@multinodeDSId, 0)
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMultinodeFederatedDataSourceId]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMultinodeFederatedDataSourceId' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'GetMultinodeFederatedDataSourceId',  '1.1.2.2', 'GetMultinodeFederatedDataSourceId', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
