

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMediaLocation.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMediaLocation'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMediaLocation]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMediaLocation]
  delete from GXDBVersions where name = 'GetMediaLocation' and type = 5
END
GO

	CREATE FUNCTION GetMediaLocation(@MediaId integer, @MediaLocation integer, @LibraryId integer, @ExportLocationId integer)
	RETURNS NVARCHAR(1024)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @location NVARCHAR(1024)
		set @location = 'Not Available'
		if @MediaLocation = 1 and @LibraryId > 0
			SELECT @location = isnull(AliasName, 'Not Available') from MMLibrary where LibraryId = @LibraryId
		if @MediaLocation = 2
			SELECT @location = isnull(DriveName, 'Not Available') from MMDrive where MediaId = @MediaId
		if @MediaLocation = 3 and @ExportLocationId > 0
			SELECT @location = isnull(ExportLocation, 'Not Available') from MMExportLocation where ExportLocationId = @ExportLocationId
		RETURN @location
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMediaLocation]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMediaLocation' AND revision = '1.1.300.1')

  insert into GXDBVersions values(5, 'GetMediaLocation',  '1.1.300.1', 'GetMediaLocation', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
