

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMediaList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMediaList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMediaList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMediaList]
  delete from GXDBVersions where name = 'GetMediaList' and type = 5
END
GO

	CREATE FUNCTION GetMediaList(@JobId integer)
	RETURNS VARCHAR(1024)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @mediaList VARCHAR(1024) SET @mediaList =''
		DECLARE @t_barcode VARCHAR(1024)
		DECLARE @t_mediaId INT
		IF @JobId >  0
		BEGIN
			DECLARE getMediaList CURSOR FOR
				SELECT DISTINCT M.mediaId, M.barcode FROM MMMedia M,JMJobResourceHistory R
				WHERE R.mediaId = M.mediaId AND R.jobid = @JobId
			OPEN getMediaList
			FETCH NEXT FROM getMediaList INTO @t_mediaId, @t_barcode
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @mediaList != ''
					SET @mediaList = @mediaList + ', '
				IF  @t_barcode = 'CV_MAGNETIC'
					SET @mediaList = @mediaList + (SELECT aliasName from MMDrive where MediaId = @t_mediaId)
				ELSE
					SET @mediaList = @mediaList + @t_barcode
				FETCH NEXT FROM getMediaList INTO @t_mediaId, @t_barcode
			END
			CLOSE getMediaList
			DEALLOCATE getMediaList
		END
		RETURN @mediaList
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMediaList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMediaList' AND revision = '1.1.276.1')

  insert into GXDBVersions values(5, 'GetMediaList',  '1.1.276.1', 'GetMediaList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
