

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMaxRetentionTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMaxRetentionTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMaxRetentionTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMaxRetentionTime]
  delete from GXDBVersions where name = 'GetMaxRetentionTime' and type = 5
END
GO

	CREATE FUNCTION GetMaxRetentionTime(@inJobId integer, @inCommcellId integer, @jobStartTime integer)
	RETURNS BIGINT
	-- WITH ENCRYPTION
	AS
	BEGIN

	DECLARE @MAXINT					bigint
	DECLARE @retentionDays			bigint
	DECLARE @extendedRetentionDays	bigint
	DECLARE @manualRetentionTime	bigint
	DECLARE @retentionTime			bigint
	SET @MAXINT = 0x7FFFFFFFFFFFFFFF
	SET @retentionDays = 0
	SET @extendedRetentionDays = 0
	SET @manualRetentionTime = 0
	SET @retentionTime = 0

	IF EXISTS(SELECT 1 FROM JMBkpStats WITH(NOLOCK) WHERE jobId = @inJobId AND commcellId = @inCommcellId AND dataStatus IN(1, 2))
	BEGIN
		SELECT @retentionTime = CASE WHEN agedTime > 0 THEN agedTime WHEN mediaDeletedTime > 0 THEN mediaDeletedTime ELSE @jobStartTime END
		FROM JMBkpStats WITH(NOLOCK)
		WHERE jobId = @inJobId AND commcellId = @inCommcellId

		RETURN @retentionTime
	END
	ELSE IF EXISTS (SELECT 1 FROM JMAdminJobStatsTable WITH(NOLOCK) WHERE jobId = @inJobId AND commcellId = @inCommcellId AND dataStatus IN(1, 2))
	BEGIN
		SELECT @retentionTime = CASE WHEN ISNULL(MAX(agedTime), 0) > 0 THEN MAX(agedTime) WHEN ISNULL(MAX(mediaDeletedTime), 0) > 0 THEN MAX(mediaDeletedTime) ELSE @jobStartTime END
		FROM JMJobDataStats WITH(NOLOCK) WHERE jobId = @inJobId AND commcellId = @inCommcellId

		RETURN @retentionTime
	END

	declare @tempJobRetention table(
		jobId INT, commCellId INT, archGrpCopyId INT,
		retentionDays BIGINT, extRetentionFlags INT, extRetentionDays BIGINT,
		manualRetentionEndTime BIGINT, manualRetaided INT)

	INSERT INTO @tempJobRetention
	SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
			(case when J.AppType in (SELECT appTypeId FROM APP_IDATypeHandlingInfo WITH (NOLOCK) WHERE isDMAppType = 1)
			 then A.archiverRetDays else A.retentionDays end),
			B.retentionFlags, 0,
			(case when B.manualRetentionEndTime < 0 then @MAXINT else B.manualRetentionEndTime end) AS manualRetentionEndTime, B.disabled & 2
	FROM	JMJobDataStats B WITH (NOLOCK), JmBkpStats J WITH (NOLOCK),
			(SELECT AR.copyId,
					(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays,
					(case when AR.archiverRetDays < 0 then @MAXINT else AR.archiverRetDays end) AS archiverRetDays
			FROM	archAgingRule AR WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
			WHERE	AR.copyId = AGC.id ) A
	WHERE J.jobId = @inJobId AND J.commCellId = @inCommcellId AND
	B.commCellId = J.commCellId AND B.jobId = J.jobId
		AND (B.status IN (2, 100, 102, 103) OR (B.status = 101 AND B.disabled & 1 = 0))
		AND A.copyId = B.archGrpCopyId
		AND J.appId = B.appId

	UPDATE	@tempJobRetention
	SET		extRetentionFlags = (
	case
	when extRetentionFlags & 64 <> 0 OR extRetentionFlags & 4096 <> 0  then 64
	when extRetentionFlags & 32 <> 0 OR extRetentionFlags & 2048 <> 0  then 32
	when extRetentionFlags & 16 <> 0 OR extRetentionFlags & 1024 <> 0  then 16
	when extRetentionFlags & 8 <> 0 OR extRetentionFlags & 512 <> 0    then 8
	when extRetentionFlags & 4 <> 0 OR extRetentionFlags & 256 <> 0    then 4
	when extRetentionFlags & 524288 <> 0 OR extRetentionFlags & 8388608 <> 0    then 524288
	when extRetentionFlags & 262144 <> 0 OR extRetentionFlags & 4194304 <> 0    then 262144
	when extRetentionFlags & 2 <> 0  then 2
	end)
	WHERE	extRetentionFlags <> 0

	UPDATE	@tempJobRetention
	SET		extRetentionDays = case when b.retentionDays < 0 then @MAXINT else b.retentionDays end
	FROM	@tempJobRetention a,
			(SELECT AR.copyId, AR.retentionRule,
			AR.retentionDays AS retentionDays
			FROM	archAgingRuleExtended AR WITH (READUNCOMMITTED), archGroupCopy AGC WITH (NOLOCK)
			WHERE	AR.copyId = AGC.id ) b
	WHERE	b.copyId = a.archGrpCopyId AND b.retentionRule = a.extRetentionFlags

	SELECT	@retentionDays = MAX(retentionDays), @extendedRetentionDays = MAX(extRetentionDays), @manualRetentionTime = MAX(manualRetentionEndTime)
	FROM	@tempJobRetention
	GROUP BY jobId, commCellId

	IF @retentionDays = @MAXINT OR @extendedRetentionDays = @MAXINT OR @manualRetentionTime = @MAXINT -- Infinite Retention
		SET @retentionTime = -1 -- Infinite Retention
	ELSE
	BEGIN
		IF @retentionDays >= 0 and @extendedRetentionDays > @retentionDays -- Extended Retention check
			SET @retentionDays = @extendedRetentionDays
		SET @retentionTime = @retentionDays
		IF @retentionDays >= 0
		BEGIN
			IF @manualRetentionTime > (@jobStartTime + @retentionDays*24*60*60) -- Manual Retention check
				SET  @retentionTime = @manualRetentionTime
			ELSE
				SET @retentionTime = @jobStartTime + @retentionDays*24*60*60
		END
	END
	RETURN @retentionTime
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMaxRetentionTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMaxRetentionTime' AND revision = '1.7.14.3')

  insert into GXDBVersions values(5, 'GetMaxRetentionTime',  '1.7.14.3', 'GetMaxRetentionTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
