

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobTypeForJobID.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobTypeForJobID'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobTypeForJobID]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobTypeForJobID]
  delete from GXDBVersions where name = 'GetJobTypeForJobID' and type = 5
END
GO

	CREATE FUNCTION GetJobTypeForJobID(@JobId bigint)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobCategory	INTEGER
		DECLARE @opType			INTEGER
		SELECT @jobCategory = jobCategory, @opType = opType FROM JMJobInfo WHERE jobId = @JobId
		IF(@jobCategory IS NULL)
		BEGIN
			RETURN -1
		END
		ELSE
		BEGIN
			SET @opType = CASE @jobCategory
			WHEN 1 THEN 4
			WHEN 2 THEN 5
			ELSE ISNULL(@opType,-1)
			END
		END
		RETURN @opType
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobTypeForJobID]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobTypeForJobID' AND revision = '1.3.304.1')

  insert into GXDBVersions values(5, 'GetJobTypeForJobID',  '1.3.304.1', 'GetJobTypeForJobID', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
