

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobStatusString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobStatusString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobStatusString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobStatusString]
  delete from GXDBVersions where name = 'GetJobStatusString' and type = 5
END
GO

	CREATE FUNCTION GetJobStatusString (@localeId INT, @statusId INTEGER)
	RETURNS VARCHAR(255)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobStatusName varchar(255)
		SELECT @jobStatusName =
			CASE @statusId
			WHEN 1 THEN 'Completed'
			WHEN 2 THEN 'Completed with errors'
			WHEN 3 THEN 'Completed with warnings'
			WHEN 4 THEN 'Failed'
			WHEN 5 THEN 'Killed'
			WHEN 6 THEN 'Delayed'
			WHEN 7 THEN 'Running'
			WHEN 8 THEN 'No Run'
			WHEN 9 THEN 'Committed'
			ELSE 'Unknown' END

	IF	@localeId > 0
		SELECT	@jobStatusName = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @jobStatusName)

	RETURN @jobStatusName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobStatusString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobStatusString' AND revision = '1.4.2.1')

  insert into GXDBVersions values(5, 'GetJobStatusString',  '1.4.2.1', 'GetJobStatusString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
