

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobStatusForReport.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobStatusForReport'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobStatusForReport]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobStatusForReport]
  delete from GXDBVersions where name = 'GetJobStatusForReport' and type = 5
END
GO

 CREATE FUNCTION [GetJobStatusForReport](@statusOrStateValue INT, @isStatus bit = 1)
 RETURNS INT
 AS
 BEGIN
     DECLARE @rv INT = NULL

 	--COMPLETED               =1,
 	--COMPLETED_WITH_ERRORS   =2,
	--COMPLETED_WITH_WARNINGS =3,
	--FAILED                  =4,
	--KILLED                  =5,
	--DELAYED                 =6,
	--RUNNING                 =7,
    --NORUN                   =8

     IF @isStatus = 1 BEGIN

         SET @rv = CASE @statusOrStateValue WHEN  1 THEN  1  -- JMSUCCESS                : COMPLETED
                                            WHEN  2 THEN  4  -- FAIL                     : FAILED
                                            WHEN  3 THEN  2  -- PARTIALSUCCESS           : COMPLETED_WITH_ERRORS
                                            WHEN  4 THEN  5  -- KILLED                   : KILLED
                                            WHEN  5 THEN  6  -- STSTOPPED                : DELAYED
                                            WHEN  6 THEN  6  -- STINTERRUPTED            : DELAYED
                                            WHEN  8 THEN  8  -- STSKIPPED                : NO RUN
                                            WHEN  9 THEN  8  -- DROPPED                  : NO RUN
                                            WHEN 10 THEN  4  -- INSYNC                   : RUNNING
                                            WHEN 11 THEN  4  -- OUTOFSYNC                : RUNNING
                                            WHEN 12 THEN  7  -- NOTATTEMPTED             : RUNNING
                                            WHEN 13 THEN  7  -- CVJOBSTATUS_STARTED      : RUNNING
                                            WHEN 14 THEN  3  -- JMSUCCESSWITHWARNINGS    : COMPLETED_WITH_WARNINGS
                                            WHEN 15 THEN  4  -- SYSTEMFAILED	     : FAILED
                                            WHEN 16 THEN  9  -- COMMITTED 	             : COMPLETED_WITH_WARNINGS
                                            ELSE -1
                   END

     END ELSE BEGIN

         SET @rv = CASE @statusOrStateValue WHEN  1 THEN  7  -- RUNNING                  : RUNNING
                                            WHEN  2 THEN  6  -- PENDING                  : DELAYED
                                            WHEN  3 THEN  6  -- WAITING                  : DELAYED
                                            WHEN  4 THEN  1  -- COMPLETED                : COMPLETED
                                            WHEN  5 THEN  6  -- STOPPED                  : DELAYED
                                            WHEN  6 THEN  7  -- KILLPENDING              : RUNNING
                                            WHEN  7 THEN  7  -- STOPPENDING              : RUNNING
                                            WHEN  8 THEN  7  -- INTERRUPTPENDING         : RUNNING
                                            WHEN  9 THEN  1  -- COMPLETEDSUCCESS         : COMPLETED
                                            WHEN 10 THEN  4  -- COMPLETEDFAIL            : FAILED
                                            WHEN 11 THEN  5  -- STATEKILLED              : KILLED
                                            WHEN 12 THEN  2  -- COMPLETEDPARTIAL         : COMPLETED_WITH_ERRORS
                                            WHEN 13 THEN  7  -- SYSTEMKILLPENDING        : RUNNNING
                                            WHEN 14 THEN  6  -- DORMANT                  : DELAYED
                                            WHEN 15 THEN  6  -- QUEUED                   : DELAYED
                                            WHEN 16 THEN  6  -- DORMANTSCHEDWAIT         : DELAYED
                                            WHEN 17 THEN  7  -- RUNNING_UNVERIFIABLE     : RUNNING
                                            WHEN 18 THEN  4  -- DANGLINGJOBCLEANUP       : FAILED
                                            WHEN 19 THEN  3  -- COMPLETEDWITHWARNINGS    : COMPLETED_WITH_WARNINGS
                                            ELSE -1
                   END
     END

     RETURN @rv

 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobStatusForReport]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobStatusForReport' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetJobStatusForReport',  '1.4', 'GetJobStatusForReport', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
