

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobStateName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobStateName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobStateName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobStateName]
  delete from GXDBVersions where name = 'GetJobStateName' and type = 5
END
GO

	CREATE FUNCTION GetJobStateName (@stateId INTEGER)
	RETURNS VARCHAR(255)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobStateName varchar(255)
		SELECT @jobStateName =
			CASE @stateId
			WHEN 1 THEN 'Running'
			WHEN 2 THEN 'Pending'
			WHEN 3 THEN 'Waiting'
			WHEN 4 THEN 'Completed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Kill Pending'
			WHEN 7 THEN 'Suspend Pending'
			WHEN 8 THEN 'Interrupt Pending'
			WHEN 9 THEN 'Completed'
			WHEN 10 THEN 'Failed'
			WHEN 11 THEN 'Killed'
			WHEN 12 THEN 'Completed w/ one or more errors'
			WHEN 13 THEN 'System Kill Pending'
			WHEN 14 THEN 'Suspended'
			WHEN 15 THEN 'Queued'
			WHEN 16 THEN 'Queued'
			WHEN 17 THEN 'Running (Cannot be verified)'
			WHEN 18 THEN 'Abnormally Terminated Cleanup'
			ELSE 'Unknown' END
	RETURN @jobStateName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobStateName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobStateName' AND revision = '1.1.276.1')

  insert into GXDBVersions values(5, 'GetJobStateName',  '1.1.276.1', 'GetJobStateName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
