

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobOptionList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobOptionList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobOptionList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobOptionList]
  delete from GXDBVersions where name = 'GetJobOptionList' and type = 5
END
GO

	CREATE FUNCTION GetJobOptionList(@jobId bigint, @optionId bigint)
	RETURNS
	@listTbl table (value NVARCHAR(MAX))
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SELECT @taskId=taskId, @subTaskId=subTaskId, @refTime=created from TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId)
		--Get the list of option values from the TM_JobOptions table
		INSERT INTO @listTbl SELECT value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId OR
			(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime)))
			AND optionId = @optionId
		--INSERT INTO @listTbl SELECT value FROM TM_JobOptions WHERE jobId = @jobId AND optionId = @optionId
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobOptionList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobOptionList' AND revision = '1.8.278.1')

  insert into GXDBVersions values(5, 'GetJobOptionList',  '1.8.278.1', 'GetJobOptionList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
