

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobOptionByIDList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobOptionByIDList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobOptionByIDList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobOptionByIDList]
  delete from GXDBVersions where name = 'GetJobOptionByIDList' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION GetJobOptionByIDList(@jobId bigint, @optionIdList VARCHAR(MAX) )
	RETURNS
	@listTbl table (optionId bigint, value NVARCHAR(MAX), type INT)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created from TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE jobId=@jobId)

		declare @xml xml
		set @xml = @optionIdList

		INSERT INTO @listTbl
		SELECT DISTINCT optionId, value, type FROM TM_JobOptions WITH (READUNCOMMITTED)
		WHERE (jobId=@jobId OR
			(jobId=0 AND subTaskId=@subTaskId AND created <=@refTime AND (modified=0 OR modified >@refTime)))
		AND optionId in (
				SELECT	DISTINCT params.value('@val', 'int')
				FROM	@xml.nodes('/id') AS R(params)
				)
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobOptionByIDList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobOptionByIDList' AND revision = '1.2.200.1')

  insert into GXDBVersions values(5, 'GetJobOptionByIDList',  '1.2.200.1', 'GetJobOptionByIDList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
